/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.di.internal;

import com.simplj.di.exceptions.SdfException;
import java.io.File;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

final class Scanner {
    private static final String CLASS_EXT = ".class";

    Scanner() {
    }

    static Set<Class<?>> scanForAnnotatedClasses(String basePackage, Class<? extends Annotation> annotation) {
        HashSet classes = new HashSet();
        LinkedList<File> pkgDirs = new LinkedList<File>();
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            String pkgPath = basePackage.replace('.', '/');
            Enumeration<URL> resources = classLoader.getResources(pkgPath);
            while (resources.hasMoreElements()) {
                URL temp = resources.nextElement();
                pkgDirs.add(new File(temp.getFile()));
            }
            for (File pkgDir : pkgDirs) {
                Scanner.loadClasses(classes, pkgDir, basePackage, annotation);
            }
        }
        catch (Exception ex) {
            throw new SdfException("Could not load classes for package: " + basePackage);
        }
        return classes;
    }

    private static void loadClasses(Set<Class<?>> classes, File pkgDir, String pkg, Class<? extends Annotation> annotation) throws ClassNotFoundException {
        File[] files;
        if (null != pkgDir && pkgDir.exists() && (files = pkgDir.listFiles()) != null) {
            for (File file : files) {
                if (file.getName().endsWith(CLASS_EXT)) {
                    Class<?> temp = Class.forName(Scanner.fullyQualifiedClassName(pkg, file.getName()));
                    if (!temp.isAnnotationPresent(annotation)) continue;
                    classes.add(temp);
                    continue;
                }
                if (!file.isDirectory()) continue;
                Scanner.loadClasses(classes, file, pkg + "." + file.getName(), annotation);
            }
        }
    }

    private static String fullyQualifiedClassName(String pkg, String className) {
        return String.format("%s.%s", pkg, className.substring(0, className.length() - CLASS_EXT.length()));
    }
}

