/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.di.internal;

import com.simplj.di.exceptions.SdfException;
import com.simplj.di.internal.ConstructorInstantiator;
import com.simplj.di.internal.DependencyInstantiator;
import com.simplj.di.internal.MethodInstantiator;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

final class SingletonInstantiator
extends DependencyInstantiator {
    private final ConstructorInstantiator cInit;
    private final MethodInstantiator mInit;
    private final boolean isConsInit;
    private volatile boolean isInitialized;
    private volatile Object obj;

    SingletonInstantiator(Constructor<?> constructor) {
        this(new ConstructorInstantiator(constructor), null, true);
    }

    SingletonInstantiator(Method method, Object instance) {
        this(null, new MethodInstantiator(method, instance), false);
    }

    private SingletonInstantiator(ConstructorInstantiator c, MethodInstantiator m, boolean isConstructor) {
        this.cInit = c;
        this.mInit = m;
        this.isConsInit = isConstructor;
    }

    @Override
    Class<?> type() {
        return this.isConsInit ? this.cInit.type() : this.mInit.type();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Object instantiate(Object[] args) throws SdfException {
        if (!this.isInitialized) {
            SingletonInstantiator singletonInstantiator = this;
            synchronized (singletonInstantiator) {
                if (!this.isInitialized) {
                    if (this.cInit != null) {
                        this.obj = this.cInit.instantiate(args);
                    } else if (this.mInit != null) {
                        this.obj = this.mInit.instantiate(args);
                    }
                    this.isInitialized = true;
                }
            }
        }
        return this.obj;
    }
}

