/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.di.internal;

import com.simplj.di.internal.Kind;
import com.simplj.di.internal.TypeRef;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

final class VType
extends TypeRef {
    private final String name;
    private final AtomicBoolean isTyped;
    private TypeRef type;

    VType(Type rawType, String name) {
        super(rawType);
        this.name = name;
        this.isTyped = new AtomicBoolean(false);
    }

    public String getName() {
        return this.name;
    }

    public TypeRef getType() {
        return this.type;
    }

    @Override
    boolean isAssignableFrom(TypeRef ref) {
        return !this.isTyped() || this.type.isAssignableFrom(ref);
    }

    @Override
    public List<TypeRef> parents() {
        return this.isTyped.get() ? this.type.parents() : Collections.emptyList();
    }

    @Override
    Set<String> vTypes() {
        return this.isTyped.get() ? this.type.vTypes() : Collections.singleton(this.name);
    }

    @Override
    void updateVTypesFrom(TypeRef ref, Map<String, TypeRef> accumulator) {
        boolean flag = this.isTyped.compareAndSet(false, true);
        if (flag) {
            this.type = ref;
            accumulator.put(this.name, this.type);
        }
    }

    @Override
    void updateVTypes(Map<String, TypeRef> varTypeMap) {
        boolean flag;
        TypeRef ref = varTypeMap.get(this.name);
        if (ref != null && (flag = this.isTyped.compareAndSet(false, true))) {
            this.type = ref;
        }
    }

    @Override
    public boolean isTyped() {
        return this.isTyped.get();
    }

    @Override
    Kind kind() {
        return Kind.Variable;
    }

    @Override
    String name() {
        return this.isTyped.get() ? this.type.name() : this.name;
    }

    @Override
    String rawName() {
        return this.isTyped.get() ? this.type.rawName() : this.name();
    }

    @Override
    String typedName() {
        return this.isTyped.get() ? this.type.typedName() : Object.class.getName();
    }
}

