package com.simplj.di.annotations;

import java.lang.annotation.*;

/**
 * Use this annotation to define a dependency. Below are the options:
 * <p>
 * `id` - can be used to assign an unique id against the dependency.<p>
 * `singleton` - can be used to modify the class's singleton behavior. Default: <i>true</i><p>
 * `isDefault` - if class is child of an interface/class and there can be multiple other types of same interface/class<p>
 *                  then use this to mark this as the default implementation for the corresponding interface/class type.
 * <p>
 * Constraints:<p>
 *   1) No java.lang.* type can be used as @DependencyProvider
 *   2) `initMethod` must be present in the same class
 *   3) `initMethod` must be static
 */
@Documented
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface DependencyProvider {
    String id() default "";
    String[] tags() default {};
    String[] profiles() default {};
    boolean singleton() default true;
    boolean isDefault() default false;
}
