package com.simplj.di.core;

import com.simplj.di.exceptions.SdfException;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DependencyResolverFactory {
    private static final DependencyResolverFactory instance = new DependencyResolverFactory();
    private static final String DEFAULT_CONTEXT = "default";

    private final Map<String, DependencyResolver> resolvers;

    private DependencyResolverFactory() {
        resolvers = new ConcurrentHashMap<>();
    }

    public static DependencyResolver defaultResolver() {
        return resolver(DEFAULT_CONTEXT);
    }

    public static DependencyResolver resolver(String context) {
        DependencyResolver resolver = instance.resolvers.get(context);
        if (resolver == null) {
            throw new SdfException("DependencyResolver not found for '" + context + "' context!");
        }
        return resolver;
    }

    public static void configureDefaultResolver(DependencyResolverConfig config) {
        configureResolver(DEFAULT_CONTEXT, config);
    }

    public static void configureResolver(String context, DependencyResolverConfig config) {
        DependencyResolver resolver = new DependencyResolver();
        DependencyResolver existing = instance.resolvers.putIfAbsent(context, resolver);
        if (existing == null) {
            resolver.setup(config);
        } else {
            System.out.println("WARN: A resolver is already configured for '" + context + "' context!");
        }
    }
}
