package com.simplj.di.core;

import com.simplj.di.exceptions.SdfException;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.stream.Collectors;

public abstract class TypeClass<T> {
    private final String name;
    private final Type type;
    private final Class<T> rawType;

    @SuppressWarnings("unchecked")
    public TypeClass() throws ClassNotFoundException {
        type = getWrappedType();
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType) type;
            this.name = String.format("%s<%s>", pt.getRawType().getTypeName(), Arrays.stream(pt.getActualTypeArguments())
                    .map(Type::getTypeName).collect(Collectors.joining(",")));
            this.rawType = (Class<T>) Class.forName(pt.getRawType().getTypeName());
        } else {
            this.name = type.getTypeName();
            this.rawType = (Class<T>) Class.forName(name);
        }
    }

    private Type getWrappedType() {
        Type gType = getClass().getGenericSuperclass();
        if (gType instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType) gType;
            return pType.getActualTypeArguments()[0];
        } else throw new SdfException(gType.getTypeName() + " is not a generic type! TypeClass<T> must be used for generic type classes!");
    }

    public final String getName() {
        return name;
    }

    public final Class<T> getRawType() {
        return rawType;
    }

    public final Type getType() {
        return type;
    }

    @Override
    public final int hashCode() {
        return super.hashCode();
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    protected final Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public final String toString() {
        return getName();
    }

    @Override
    protected final void finalize() throws Throwable {
        super.finalize();
    }
}
