/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.di.core;

import com.simplj.di.core.DependencyResolverConfig;
import com.simplj.di.core.Tri;
import com.simplj.di.core.TypeClass;
import com.simplj.di.exceptions.SdfException;
import com.simplj.di.internal.TypeUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public class DependencyResolver {
    private BiFunction<Type, String, Object> typeResolverF;
    private Function<String, Object> idResolverF;
    private Tri<Type, String, Map<String, Object>, Object> dynTypeResolverF;
    private BiFunction<String, Map<String, Object>, Object> dynIdResolverF;
    private boolean isSetupDone;
    private final Object lock = new Object();

    DependencyResolver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setup(DependencyResolverConfig config) throws SdfException {
        if (!this.isSetupDone) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.isSetupDone) {
                    Object obj;
                    Class<?> loaderClass = DependencyResolver.findLoaderClass();
                    if (loaderClass == null) {
                        throw new SdfException("Could not initialize SDF! Library might be broken.");
                    }
                    Consumer<String> loggerF = config.getLoggerF();
                    if (loggerF == null) {
                        System.out.println("WARN: No logger function is set. Setting default log to console!");
                        loggerF = System.out::println;
                    }
                    try {
                        Constructor<?> cons = loaderClass.getDeclaredConstructors()[0];
                        cons.setAccessible(true);
                        obj = cons.newInstance(config.dependencyProviders(), config.basePackages(), config.properties(), config.profile(), loggerF);
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        if (e.getCause() instanceof SdfException) {
                            throw (SdfException)e.getCause();
                        }
                        throw new SdfException("Could not initialize SDF! Unable to load dependency classes.");
                    }
                    Method[] ms = loaderClass.getDeclaredMethods();
                    int count = 0;
                    for (int i = 0; i < ms.length && count < 4; ++i) {
                        Method m = ms[i];
                        if (Modifier.isStatic(m.getModifiers()) || !Object.class.equals(m.getReturnType())) continue;
                        if (m.getParameters().length == 1) {
                            m.setAccessible(true);
                            this.idResolverF = s -> this.invoke(obj, m, (String)s);
                            ++count;
                            continue;
                        }
                        if (m.getParameters().length == 2) {
                            if (m.getParameters()[0].getType().isInterface()) {
                                m.setAccessible(true);
                                this.typeResolverF = (t, g) -> this.invoke(obj, m, (Type)t, (String)g);
                            } else {
                                m.setAccessible(true);
                                this.dynIdResolverF = (s, p) -> this.invoke(obj, m, (String)s, (Map<String, Object>)p);
                            }
                            ++count;
                            continue;
                        }
                        if (m.getParameters().length != 3) continue;
                        m.setAccessible(true);
                        this.dynTypeResolverF = (t, g, p) -> this.invoke(obj, m, (Type)t, (String)g, (Map<String, Object>)p);
                        ++count;
                    }
                    if (this.typeResolverF == null || this.idResolverF == null || this.dynTypeResolverF == null || this.dynIdResolverF == null) {
                        throw new SdfException("Could not initialize SDF! Resolver method not found.");
                    }
                    this.isSetupDone = true;
                }
            }
        }
    }

    public <T> T resolve(Class<T> clazz) throws SdfException {
        return this.resolve(clazz, null);
    }

    public <T> T resolve(Class<T> clazz, String tag) throws SdfException {
        if (this.typeResolverF == null) {
            throw new SdfException("DependencyResolver is not configured!");
        }
        Object obj = this.typeResolverF.apply(clazz, tag);
        return TypeUtil.typeCast(clazz, obj);
    }

    public <T> T resolve(TypeClass<T> type) throws SdfException {
        return this.resolve(type, null);
    }

    public <T> T resolve(TypeClass<T> type, String tag) throws SdfException {
        if (this.typeResolverF == null) {
            throw new SdfException("DependencyResolver is not configured!");
        }
        Object obj = this.typeResolverF.apply(type.getType(), tag);
        return TypeUtil.typeCast(type.getRawType(), obj);
    }

    public <T> T resolve(String id, Class<T> type) throws SdfException {
        if (this.idResolverF == null) {
            throw new SdfException("DependencyResolver is not configured!");
        }
        Object obj = this.idResolverF.apply(id);
        return TypeUtil.typeCast(type, obj);
    }

    public <T> T resolve(String id, TypeClass<T> type) throws SdfException {
        return this.resolve(id, type.getRawType());
    }

    public <T> T dynamicResolve(Class<T> clazz, Map<String, Object> rtArgs) throws SdfException {
        return this.dynamicResolve(clazz, null, rtArgs);
    }

    public <T> T dynamicResolve(Class<T> clazz, String tag, Map<String, Object> rtArgs) throws SdfException {
        if (this.dynTypeResolverF == null) {
            throw new SdfException("DependencyResolver is not configured!");
        }
        Object obj = this.dynTypeResolverF.apply(clazz, tag, rtArgs);
        return TypeUtil.typeCast(clazz, obj);
    }

    public <T> T dynamicResolve(TypeClass<T> type, Map<String, Object> rtArgs) throws SdfException {
        return this.dynamicResolve(type, null, rtArgs);
    }

    public <T> T dynamicResolve(TypeClass<T> type, String tag, Map<String, Object> rtArgs) throws SdfException {
        if (this.dynTypeResolverF == null) {
            throw new SdfException("DependencyResolver is not configured!");
        }
        Object obj = this.dynTypeResolverF.apply(type.getType(), tag, rtArgs);
        return TypeUtil.typeCast(type.getRawType(), obj);
    }

    public <T> T dynamicResolve(String id, Class<T> type, Map<String, Object> rtArgs) throws SdfException {
        if (this.dynIdResolverF == null) {
            throw new SdfException("DependencyResolver is not configured!");
        }
        Object obj = this.dynIdResolverF.apply(id, rtArgs);
        return TypeUtil.typeCast(type, obj);
    }

    public <T> T dynamicResolve(String id, TypeClass<T> type, Map<String, Object> rtArgs) throws SdfException {
        return this.dynamicResolve(id, type.getRawType(), rtArgs);
    }

    private static Class<?> findLoaderClass() {
        Class<?> clazz;
        try {
            String pkg = DependencyResolver.class.getPackage().getName();
            clazz = Class.forName(String.format("%s.%s.%s", pkg.substring(0, pkg.lastIndexOf(46)), "internal", "DependencyLoader"));
        }
        catch (ClassNotFoundException ex) {
            throw new SdfException("Could not initialize SDF! Unable to find loader class.");
        }
        return clazz;
    }

    private Object invoke(Object obj, Method m, Type type, String tag) {
        try {
            return m.invoke(obj, type, tag);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            if (e.getCause() instanceof SdfException) {
                throw (SdfException)e.getCause();
            }
            throw new SdfException("Could not resolve '" + type.getTypeName() + "'. Error: Unable to invoke resolver method!");
        }
    }

    private Object invoke(Object obj, Method m, String id) {
        try {
            return m.invoke(obj, id);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            if (e.getCause() instanceof SdfException) {
                throw (SdfException)e.getCause();
            }
            throw new SdfException("Could not resolve '" + id + "'. Error: Unable to invoke resolver method!");
        }
    }

    private Object invoke(Object obj, Method m, Type type, String tag, Map<String, Object> params) {
        try {
            return m.invoke(obj, type, tag, params);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            if (e.getCause() instanceof SdfException) {
                throw (SdfException)e.getCause();
            }
            throw new SdfException("Could not resolve '" + type.getTypeName() + "'. Error: Unable to invoke resolver method!");
        }
    }

    private Object invoke(Object obj, Method m, String id, Map<String, Object> params) {
        try {
            return m.invoke(obj, id, params);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            if (e.getCause() instanceof SdfException) {
                throw (SdfException)e.getCause();
            }
            throw new SdfException("Could not resolve '" + id + "'. Error: Unable to invoke resolver method!");
        }
    }
}

