/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.di.core;

import java.util.Properties;
import java.util.function.Consumer;

public class DependencyResolverConfig {
    private final Class<?>[] dependencyProviders;
    private final String[] basePackages;
    private final Properties properties;
    private final String profile;
    private final Consumer<String> loggerF;

    private DependencyResolverConfig(Class<?>[] dependencyProviders, String[] basePackages, Properties properties, String profile, Consumer<String> loggerF) {
        this.dependencyProviders = dependencyProviders;
        this.basePackages = basePackages;
        this.properties = properties;
        this.profile = profile;
        this.loggerF = loggerF;
    }

    Class<?>[] dependencyProviders() {
        return this.dependencyProviders;
    }

    String[] basePackages() {
        return this.basePackages;
    }

    Properties properties() {
        return this.properties;
    }

    public String profile() {
        return this.profile;
    }

    public Consumer<String> getLoggerF() {
        return this.loggerF;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Class<?>[] providers;
        private String[] packages;
        private Properties props;
        private String profile;
        private Consumer<String> loggerF;

        public Builder setDependencyProviders(Class<?> ... dependencyProviders) {
            this.providers = dependencyProviders;
            return this;
        }

        public Builder setBasePackages(String ... packages) {
            this.packages = packages;
            return this;
        }

        public Builder setProperties(Properties props) {
            this.props = props;
            return this;
        }

        public Builder setProfile(String profile) {
            boolean isEmpty;
            boolean bl = isEmpty = profile == null || profile.isEmpty();
            if (isEmpty) {
                System.out.println("WARNING: Profile passed as '' (empty). This is same as resolving dependencies WITHOUT profile!");
            } else {
                this.profile = profile;
            }
            return this;
        }

        public Builder setLoggerF(Consumer<String> loggerF) {
            this.loggerF = loggerF;
            return this;
        }

        public DependencyResolverConfig build() {
            return new DependencyResolverConfig(this.providers, this.packages, this.props, this.profile, this.loggerF);
        }
    }
}

