/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.di.internal;

import com.simplj.di.annotations.Bind;
import com.simplj.di.annotations.RuntimeProvided;
import com.simplj.di.annotations.SubTypes;
import com.simplj.di.annotations.Tag;
import com.simplj.di.exceptions.SdfException;
import com.simplj.di.internal.DependencyUtil;
import com.simplj.di.internal.ParameterMeta;
import com.simplj.di.internal.TypeRef;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

final class Argument {
    private final Parameter parameter;
    private final TypeRef typeRef;
    private final int index;
    private final ParameterMeta rtp;
    private final ParameterMeta subTypes;
    private final boolean isRuntimeProvided;
    private final boolean isIdBound;
    private final boolean isSubTypes;
    private final String typeNameOrId;
    private final boolean isSubstituted;
    private final String substitutedFrom;
    private final String tag;

    Argument(String srcClass, Parameter parameter, int index, Function<String, Optional<String>> varExcerptF) throws SdfException {
        this.parameter = parameter;
        this.index = index;
        RuntimeProvided rtp = parameter.getAnnotation(RuntimeProvided.class);
        Bind bind = parameter.getAnnotation(Bind.class);
        SubTypes st = parameter.getAnnotation(SubTypes.class);
        this.isRuntimeProvided = rtp != null;
        this.isIdBound = bind != null;
        this.isSubTypes = st != null;
        int sum = (this.isIdBound ? 1 : 0) + (this.isRuntimeProvided ? 1 : 0) + (this.isSubTypes ? 1 : 0);
        if (sum > 1) {
            throw new SdfException("Either of @Bind/@RuntimeProvided/@SubTypes can be used on a parameter. Multiple annotations are used on parameter at index " + index + " in '" + srcClass + '\'');
        }
        if (this.isRuntimeProvided) {
            if (DependencyUtil.isVariableKey(rtp.key())) {
                throw new SdfException("Variable key is not expected with @RuntimeProvided! Parameter at index " + index + " in '" + srcClass + "' has variable key.");
            }
            this.typeRef = TypeRef.fromParameter(parameter);
            this.rtp = new ParameterMeta(rtp.key(), rtp.nullable(), parameter.getType());
            this.subTypes = null;
            this.isSubstituted = false;
            this.substitutedFrom = null;
            this.typeNameOrId = null;
        } else if (this.isSubTypes) {
            this.rtp = null;
            boolean isMap = parameter.getType().equals(Map.class);
            boolean isList = parameter.getType().equals(List.class);
            if (!isMap && !isList) {
                throw new SdfException("Only `Map` or `List` type is supported to have @SubTypes annotation! @SubTypes parameter at index " + index + " in '" + srcClass + "' has type: " + parameter.getType());
            }
            ParameterizedType pt = (ParameterizedType)parameter.getParameterizedType();
            int idx = 0;
            if (isMap) {
                String keyType = pt.getActualTypeArguments()[idx].getTypeName();
                if (!String.class.getName().equals(keyType)) {
                    throw new SdfException("@SubTypes Map must contain String as key! Parameter at index " + index + " in '" + srcClass + "' has '" + keyType + "' as key.");
                }
                idx = 1;
            }
            this.typeRef = TypeRef.fromType(pt.getActualTypeArguments()[idx]);
            if (!this.typeRef.vTypes().isEmpty()) {
                throw new SdfException("Type Variable in @SubTypes is not allowed! @SubTypes parameter at index " + index + " in '" + srcClass + "' has type: " + this.typeRef.name());
            }
            this.subTypes = new ParameterMeta(this.typeRef.rawName(), st.emptyIfNotFound(), parameter.getType());
            this.isSubstituted = false;
            this.substitutedFrom = null;
            this.typeNameOrId = null;
        } else {
            this.typeRef = TypeRef.fromParameter(parameter);
            this.rtp = null;
            this.subTypes = null;
            if (this.isIdBound) {
                String id = bind.id();
                Optional<String> optSubsId = varExcerptF.apply(id);
                this.isSubstituted = optSubsId.isPresent();
                this.substitutedFrom = id;
                this.typeNameOrId = optSubsId.orElse(id);
            } else {
                if (!this.typeRef.vTypes().isEmpty()) {
                    throw new SdfException("Type Variable in Parameter is not allowed! Parameter at index " + index + " in '" + srcClass + "' has type: " + this.typeRef.name());
                }
                this.isSubstituted = false;
                this.substitutedFrom = null;
                this.typeNameOrId = this.typeRef.name();
            }
        }
        Tag tag = parameter.getAnnotation(Tag.class);
        this.tag = tag == null ? null : tag.name();
    }

    public void updateVTypesFrom(TypeRef typeRef, Map<String, TypeRef> vTypeMap) {
        this.typeRef.updateVTypesFrom(typeRef, vTypeMap);
    }

    public TypeRef getTypeRef() {
        return this.typeRef;
    }

    Class<?> getType() {
        return this.parameter.getType();
    }

    String getTypeNameOrId() {
        return this.typeNameOrId;
    }

    int getIndex() {
        return this.index;
    }

    boolean isSubstituted() {
        return this.isSubstituted;
    }

    public boolean isIdBound() {
        return this.isIdBound;
    }

    boolean isRuntimeProvided() {
        return this.isRuntimeProvided;
    }

    public boolean isSubTypes() {
        return this.isSubTypes;
    }

    String getSubstitutedFrom() {
        return this.substitutedFrom;
    }

    ParameterMeta getRuntimeProvided() {
        return this.rtp;
    }

    ParameterMeta getSubTypesMeta() {
        return this.subTypes;
    }

    public String getTag() {
        return this.tag;
    }

    public String toString() {
        return String.format("{arg: idx=%s, typeNameOrId=%s}", this.index, this.typeNameOrId);
    }
}

