/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.di.internal;

import com.simplj.di.internal.BType;
import com.simplj.di.internal.Kind;
import com.simplj.di.internal.LBType;
import com.simplj.di.internal.PType;
import com.simplj.di.internal.TypeRef;
import com.simplj.di.internal.UBType;
import com.simplj.di.internal.VType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class CType
extends TypeRef {
    private final Class<?> type;
    private final List<TypeRef> parentTypes;

    CType(Class<?> type, List<TypeRef> parents) {
        super(type);
        this.type = type;
        this.parentTypes = parents;
    }

    Class<?> getType() {
        return this.type;
    }

    @Override
    boolean isAssignableFrom(TypeRef ref) {
        boolean res = false;
        if (ref != null) {
            switch (ref.kind()) {
                case Concrete: {
                    CType cType = (CType)ref;
                    res = this.type.isAssignableFrom(cType.type);
                    break;
                }
                case Parameterized: {
                    PType pType = (PType)ref;
                    res = this.type.isAssignableFrom(pType.getType());
                    break;
                }
                case Bounded: {
                    BType bType = (BType)ref;
                    res = bType.getTypes().stream().allMatch(this::isAssignableFrom);
                    break;
                }
                case UpperBounded: {
                    UBType ubType = (UBType)ref;
                    res = ubType.getTypes().stream().allMatch(this::isAssignableFrom);
                    break;
                }
                case LowerBounded: {
                    LBType lbType = (LBType)ref;
                    res = lbType.getTypes().stream().allMatch(t -> t.isAssignableFrom(this));
                    break;
                }
                case Variable: {
                    VType vType = (VType)ref;
                    res = !vType.isTyped() || this.isAssignableFrom(vType.getType());
                }
            }
        }
        return res;
    }

    @Override
    public List<TypeRef> parents() {
        return this.parentTypes;
    }

    @Override
    Set<String> vTypes() {
        return Collections.emptySet();
    }

    @Override
    void updateVTypesFrom(TypeRef ref, Map<String, TypeRef> accumulator) {
    }

    @Override
    void updateVTypes(Map<String, TypeRef> varTypeMap) {
    }

    @Override
    boolean isTyped() {
        return true;
    }

    @Override
    Kind kind() {
        return Kind.Concrete;
    }

    @Override
    String name() {
        return this.sn ? this.type.getSimpleName() : this.type.getTypeName();
    }

    @Override
    String rawName() {
        return this.name();
    }

    @Override
    String typedName() {
        return this.name();
    }
}

