/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.di.internal;

import com.simplj.di.internal.AType;
import com.simplj.di.internal.Kind;
import com.simplj.di.internal.TypeRef;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class GAType
extends TypeRef {
    private final TypeRef type;
    private final int dimensions;
    private final String brackets;

    public GAType(GenericArrayType gaType) {
        super(gaType);
        int t = 1;
        StringBuilder sb = new StringBuilder("[]");
        Type type = gaType.getGenericComponentType();
        while (type instanceof GenericArrayType) {
            gaType = (GenericArrayType)type;
            ++t;
            type = gaType.getGenericComponentType();
            sb.append("[]");
        }
        this.type = GAType.fromType(type);
        this.dimensions = t;
        this.brackets = sb.toString();
    }

    public TypeRef getType() {
        return this.type;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    @Override
    boolean isAssignableFrom(TypeRef ref) {
        boolean res = false;
        if (ref != null) {
            switch (ref.kind()) {
                case Array: {
                    AType aType = (AType)ref;
                    res = this.dimensions == aType.getDimensions() && this.type.isAssignableFrom(aType.getcType());
                    break;
                }
                case GenericArray: {
                    GAType gaType = (GAType)ref;
                    res = this.dimensions == gaType.dimensions && this.type.isAssignableFrom(gaType.type);
                }
            }
        }
        return res;
    }

    @Override
    public List<TypeRef> parents() {
        return this.type.parents();
    }

    @Override
    Set<String> vTypes() {
        return this.type.vTypes();
    }

    @Override
    void updateVTypesFrom(TypeRef ref, Map<String, TypeRef> accumulator) {
        GAType gaType = ref.getAsGAType();
        if (gaType != null) {
            this.type.updateVTypesFrom(gaType.type, accumulator);
        }
    }

    @Override
    void updateVTypes(Map<String, TypeRef> varTypeMap) {
        this.type.updateVTypes(varTypeMap);
    }

    @Override
    boolean isTyped() {
        return this.type.isTyped();
    }

    @Override
    Kind kind() {
        return Kind.GenericArray;
    }

    @Override
    String name() {
        return String.format("%s%s", this.type.name(), this.brackets);
    }

    @Override
    String rawName() {
        return String.format("%s%s", this.type.rawName(), this.brackets);
    }

    @Override
    String typedName() {
        return String.format("%s%s", this.type.typedName(), this.brackets);
    }

    String formattedTypeName(TypeRef ref) {
        return String.format("%s%s", ref.typedName(), this.brackets);
    }

    String formattedRawName(TypeRef ref) {
        return String.format("%s%s", ref.rawName(), this.brackets);
    }
}

