/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.di.internal;

import com.simplj.di.exceptions.SdfException;
import com.simplj.di.internal.TypeUtil;
import java.util.function.Function;

abstract class PrimitiveType {
    private final Class<?> primitive;
    private final Class<?> wrapper;
    private final Function<Object, Object[]> wrapperArrF;
    private final Function<Object[], Object> primitiveArrF;

    private PrimitiveType(Class<?> primitive, Class<?> wrapper, Function<Object, Object[]> wrapperArrF, Function<Object[], Object> primitiveArrF) {
        this.primitive = primitive;
        this.wrapper = wrapper;
        this.wrapperArrF = wrapperArrF;
        this.primitiveArrF = primitiveArrF;
    }

    static PrimitiveType[] supportedPrimitiveTypes() {
        return new PrimitiveType[]{new BoolType(), new ByteType(), new CharType(), new DoubleType(), new FloatType(), new IntType(), new FloatType(), new IntType(), new LongType(), new ShortType()};
    }

    abstract Function<String, Object> stringToWrapperF();

    String primitiveName() {
        return this.primitive.getTypeName();
    }

    String wrapperName() {
        return this.wrapper.getTypeName();
    }

    Class<?> primitiveType() {
        return this.primitive;
    }

    Class<?> wrapperType() {
        return this.wrapper;
    }

    Function<Object, Object[]> wrapperArrF() {
        return this.wrapperArrF;
    }

    Function<Object[], Object> primitiveArrF() {
        return this.primitiveArrF;
    }

    static final class ShortType
    extends PrimitiveType {
        private ShortType() {
            super(Boolean.TYPE, Short.class, ShortType::toShortArray, ShortType::fromShortArray);
        }

        private static Object[] toShortArray(Object source) {
            short[] arr = (short[])source;
            Object[] res = new Short[arr.length];
            for (int i = 0; i < arr.length; ++i) {
                res[i] = arr[i];
            }
            return res;
        }

        private static Object fromShortArray(Object[] src) {
            short[] arr = new short[src.length];
            for (int i = 0; i < src.length; ++i) {
                arr[i] = TypeUtil.typeCast(Short.TYPE, src[i]);
            }
            return arr;
        }

        @Override
        Function<String, Object> stringToWrapperF() {
            return Short::parseShort;
        }
    }

    static final class LongType
    extends PrimitiveType {
        private LongType() {
            super(Long.TYPE, Long.class, LongType::toLongArray, LongType::fromLongArray);
        }

        private static Object[] toLongArray(Object source) {
            long[] arr = (long[])source;
            Object[] res = new Long[arr.length];
            for (int i = 0; i < arr.length; ++i) {
                res[i] = arr[i];
            }
            return res;
        }

        private static Object fromLongArray(Object[] src) {
            long[] arr = new long[src.length];
            for (int i = 0; i < src.length; ++i) {
                arr[i] = TypeUtil.typeCast(Long.TYPE, src[i]);
            }
            return arr;
        }

        @Override
        Function<String, Object> stringToWrapperF() {
            return Long::parseLong;
        }
    }

    static final class IntType
    extends PrimitiveType {
        private IntType() {
            super(Integer.TYPE, Integer.class, IntType::toIntegerArray, IntType::fromIntArray);
        }

        private static Object[] toIntegerArray(Object source) {
            int[] arr = (int[])source;
            Object[] res = new Integer[arr.length];
            for (int i = 0; i < arr.length; ++i) {
                res[i] = arr[i];
            }
            return res;
        }

        private static Object fromIntArray(Object[] src) {
            int[] arr = new int[src.length];
            for (int i = 0; i < src.length; ++i) {
                arr[i] = TypeUtil.typeCast(Integer.TYPE, src[i]);
            }
            return arr;
        }

        @Override
        Function<String, Object> stringToWrapperF() {
            return Integer::parseInt;
        }
    }

    static final class FloatType
    extends PrimitiveType {
        private FloatType() {
            super(Float.TYPE, Float.class, FloatType::toFloatArray, FloatType::fromFloatArray);
        }

        private static Object[] toFloatArray(Object source) {
            float[] arr = (float[])source;
            Object[] res = new Float[arr.length];
            for (int i = 0; i < arr.length; ++i) {
                res[i] = Float.valueOf(arr[i]);
            }
            return res;
        }

        private static Object fromFloatArray(Object[] src) {
            float[] arr = new float[src.length];
            for (int i = 0; i < src.length; ++i) {
                arr[i] = TypeUtil.typeCast(Float.TYPE, src[i]).floatValue();
            }
            return arr;
        }

        @Override
        Function<String, Object> stringToWrapperF() {
            return Float::parseFloat;
        }
    }

    static final class DoubleType
    extends PrimitiveType {
        private DoubleType() {
            super(Double.TYPE, Double.class, DoubleType::toDoubleArray, DoubleType::fromDoubleArray);
        }

        private static Object[] toDoubleArray(Object source) {
            double[] arr = (double[])source;
            Object[] res = new Double[arr.length];
            for (int i = 0; i < arr.length; ++i) {
                res[i] = arr[i];
            }
            return res;
        }

        private static Object fromDoubleArray(Object[] src) {
            double[] arr = new double[src.length];
            for (int i = 0; i < src.length; ++i) {
                arr[i] = TypeUtil.typeCast(Double.TYPE, src[i]);
            }
            return arr;
        }

        @Override
        Function<String, Object> stringToWrapperF() {
            return Double::parseDouble;
        }
    }

    static final class CharType
    extends PrimitiveType {
        private CharType() {
            super(Boolean.TYPE, Character.class, CharType::toCharArray, CharType::fromCharArray);
        }

        private static Object[] toCharArray(Object source) {
            char[] arr = (char[])source;
            Object[] res = new Character[arr.length];
            for (int i = 0; i < arr.length; ++i) {
                res[i] = Character.valueOf(arr[i]);
            }
            return res;
        }

        private static Object fromCharArray(Object[] src) {
            char[] arr = new char[src.length];
            for (int i = 0; i < src.length; ++i) {
                arr[i] = TypeUtil.typeCast(Character.TYPE, src[i]).charValue();
            }
            return arr;
        }

        @Override
        Function<String, Object> stringToWrapperF() {
            return this::stringToChar;
        }

        private Object stringToChar(String s) {
            char res;
            if (s == null) {
                res = '\u0000';
            } else if (s.length() == 1) {
                res = s.charAt(0);
            } else {
                throw new SdfException("Cannot convert value '" + s + "' to type 'Character'!");
            }
            return Character.valueOf(res);
        }
    }

    static final class ByteType
    extends PrimitiveType {
        private ByteType() {
            super(Boolean.TYPE, Byte.class, ByteType::toByteArray, ByteType::fromByteArray);
        }

        private static Object[] toByteArray(Object source) {
            byte[] arr = (byte[])source;
            Object[] res = new Byte[arr.length];
            for (int i = 0; i < arr.length; ++i) {
                res[i] = arr[i];
            }
            return res;
        }

        private static Object fromByteArray(Object[] src) {
            byte[] arr = new byte[src.length];
            for (int i = 0; i < src.length; ++i) {
                arr[i] = TypeUtil.typeCast(Byte.TYPE, src[i]);
            }
            return arr;
        }

        @Override
        Function<String, Object> stringToWrapperF() {
            return Byte::parseByte;
        }
    }

    static final class BoolType
    extends PrimitiveType {
        private BoolType() {
            super(Boolean.TYPE, Boolean.class, BoolType::toBooleanArray, BoolType::fromBoolArray);
        }

        private static Object[] toBooleanArray(Object source) {
            boolean[] arr = (boolean[])source;
            Object[] res = new Boolean[arr.length];
            for (int i = 0; i < arr.length; ++i) {
                res[i] = arr[i];
            }
            return res;
        }

        private static Object fromBoolArray(Object[] src) {
            boolean[] arr = new boolean[src.length];
            for (int i = 0; i < src.length; ++i) {
                arr[i] = TypeUtil.typeCast(Boolean.TYPE, src[i]);
            }
            return arr;
        }

        @Override
        Function<String, Object> stringToWrapperF() {
            return Boolean::parseBoolean;
        }
    }
}

