/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.di.core;

import com.simplj.di.core.AbstractLoader;
import com.simplj.di.core.DependencyResolverConfig;
import com.simplj.di.core.TypeClass;
import com.simplj.di.exceptions.SdfException;
import com.simplj.di.internal.TypeUtil;
import com.simplj.di.model.DynamicMethod;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;

public class DependencyResolver {
    private AbstractLoader loader;
    private boolean isSetupDone;
    private final Object lock = new Object();

    DependencyResolver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setup(String context, DependencyResolverConfig config) throws SdfException {
        if (!this.isSetupDone) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.isSetupDone) {
                    Class<?> loaderClass = DependencyResolver.findLoaderClass();
                    if (loaderClass == null) {
                        throw new SdfException("Could not initialize SDF! Library might be broken.");
                    }
                    Consumer<String> loggerF = config.getLoggerF();
                    if (loggerF == null) {
                        System.out.println("WARN: No logger function is set. Setting default log to console!");
                        loggerF = System.out::println;
                    }
                    String profile = Optional.ofNullable(System.getProperty(String.format("sdf.%s.profile", context))).filter(s -> !s.trim().isEmpty()).orElse(config.profile());
                    try {
                        Constructor<?> cons = loaderClass.getDeclaredConstructors()[0];
                        cons.setAccessible(true);
                        this.loader = (AbstractLoader)cons.newInstance(config.dependencyProviders(), config.basePackages(), config.properties(), profile, config.dependencyInstances(), loggerF, config.dynamicMethodFlag(), config.overriddenAliases());
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        if (e.getCause() instanceof SdfException) {
                            throw (SdfException)e.getCause();
                        }
                        throw new SdfException("Could not initialize SDF! Unable to load dependency classes.");
                    }
                    this.isSetupDone = true;
                }
            }
        }
    }

    public <T> T resolve(Class<T> clazz) throws SdfException {
        return this.resolve(clazz, null);
    }

    public <T> T resolve(Class<T> clazz, String tag) throws SdfException {
        if (this.loader == null) {
            throw new SdfException("DependencyResolver is not configured!");
        }
        Object obj = this.loader.get(clazz, tag);
        return TypeUtil.typeCast(clazz, obj);
    }

    public <T> T resolve(TypeClass<T> type) throws SdfException {
        return this.resolve(type, null);
    }

    public <T> T resolve(TypeClass<T> type, String tag) throws SdfException {
        if (this.loader == null) {
            throw new SdfException("DependencyResolver is not configured!");
        }
        Object obj = this.loader.get(type.getType(), tag);
        return TypeUtil.typeCast(type.getRawType(), obj);
    }

    public <T> T resolve(String id, Class<T> type) throws SdfException {
        if (this.loader == null) {
            throw new SdfException("DependencyResolver is not configured!");
        }
        Object obj = this.loader.get(id);
        return TypeUtil.typeCast(type, obj);
    }

    public <T> T resolve(String id, TypeClass<T> type) throws SdfException {
        return this.resolve(id, type.getRawType());
    }

    public <T> T dynamicResolve(Class<T> clazz, Map<String, Object> rtArgs) throws SdfException {
        return this.dynamicResolve(clazz, null, rtArgs);
    }

    public <T> T dynamicResolve(Class<T> clazz, String tag, Map<String, Object> rtArgs) throws SdfException {
        if (this.loader == null) {
            throw new SdfException("DependencyResolver is not configured!");
        }
        Object obj = this.loader.get(clazz, tag, rtArgs);
        return TypeUtil.typeCast(clazz, obj);
    }

    public <T> T dynamicResolve(TypeClass<T> type, Map<String, Object> rtArgs) throws SdfException {
        return this.dynamicResolve(type, null, rtArgs);
    }

    public <T> T dynamicResolve(TypeClass<T> type, String tag, Map<String, Object> rtArgs) throws SdfException {
        if (this.loader == null) {
            throw new SdfException("DependencyResolver is not configured!");
        }
        Object obj = this.loader.get(type.getType(), tag, rtArgs);
        return TypeUtil.typeCast(type.getRawType(), obj);
    }

    public <T> T dynamicResolve(String id, Class<T> type, Map<String, Object> rtArgs) throws SdfException {
        if (this.loader == null) {
            throw new SdfException("DependencyResolver is not configured!");
        }
        Object obj = this.loader.get(id, rtArgs);
        return TypeUtil.typeCast(type, obj);
    }

    public <T> T dynamicResolve(String id, TypeClass<T> type, Map<String, Object> rtArgs) throws SdfException {
        return this.dynamicResolve(id, type.getRawType(), rtArgs);
    }

    public <T> T invoke(String method, Class<T> returnType, Object ... args) throws SdfException {
        Object obj = this.invoke(method, args);
        return TypeUtil.typeCast(returnType, obj);
    }

    public <T> T invoke(String method, TypeClass<T> returnType, Object ... args) throws SdfException {
        Object obj = this.invoke(method, args);
        return TypeUtil.typeCast(returnType.getRawType(), obj);
    }

    public <T> T invoke(String method, Class<T> returnType, Map<String, Object> rtParams, Object ... args) throws SdfException {
        Object obj = this.invoke(method, rtParams, args);
        return TypeUtil.typeCast(returnType, obj);
    }

    public <T> T invoke(String method, TypeClass<T> returnType, Map<String, Object> rtParams, Object ... args) throws SdfException {
        Object obj = this.invoke(method, rtParams, args);
        return TypeUtil.typeCast(returnType.getRawType(), obj);
    }

    public Object invoke(String method, Object ... args) throws SdfException {
        if (this.loader == null) {
            throw new SdfException("DependencyResolver is not configured!");
        }
        return this.loader.invoke(method, args);
    }

    public Object invoke(String method, Map<String, Object> rtParams, Object ... args) throws SdfException {
        if (this.loader == null) {
            throw new SdfException("DependencyResolver is not configured!");
        }
        return this.loader.invoke(method, rtParams, args);
    }

    public Map<String, DynamicMethod> resolvedDynamicMethods() {
        if (this.loader == null) {
            throw new SdfException("DependencyResolver is not configured!");
        }
        return this.loader.getDynamicMethods();
    }

    private static Class<?> findLoaderClass() {
        Class<?> clazz;
        try {
            String pkg = DependencyResolver.class.getPackage().getName();
            clazz = Class.forName(String.format("%s.%s.%s", pkg.substring(0, pkg.lastIndexOf(46)), "internal", "DependencyLoader"));
        }
        catch (ClassNotFoundException ex) {
            throw new SdfException("Could not initialize SDF! Unable to find loader class.");
        }
        return clazz;
    }
}

