/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.di.core;

import com.simplj.di.annotations.Constant;
import com.simplj.di.annotations.DependencyProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;

public class DependencyResolverConfig {
    private final Object[] dependencyProviders;
    private final String[] basePackages;
    private final Properties properties;
    private final Object[] dependencyInstances;
    private final String profile;
    private final Consumer<String> loggerF;
    private final boolean dynamicMethodFlag;
    private final Map<String, String> overriddenAliases;

    private DependencyResolverConfig(Object[] dependencyProviders, String[] basePackages, Properties properties, Object[] dependencyInstances, String profile, Consumer<String> loggerF, boolean dynamicMethodFlag, Map<String, String> overriddenAliases) {
        this.dependencyProviders = dependencyProviders;
        this.basePackages = basePackages;
        this.properties = properties;
        this.dependencyInstances = dependencyInstances;
        this.profile = profile;
        this.loggerF = loggerF;
        this.dynamicMethodFlag = dynamicMethodFlag;
        this.overriddenAliases = overriddenAliases;
    }

    Object[] dependencyProviders() {
        return this.dependencyProviders;
    }

    String[] basePackages() {
        return this.basePackages;
    }

    Properties properties() {
        return this.properties;
    }

    public Object[] dependencyInstances() {
        return this.dependencyInstances;
    }

    public String profile() {
        return this.profile;
    }

    public Consumer<String> getLoggerF() {
        return this.loggerF;
    }

    public boolean dynamicMethodFlag() {
        return this.dynamicMethodFlag;
    }

    public Map<String, String> overriddenAliases() {
        return this.overriddenAliases;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Object[] providers;
        private String[] packages;
        private Properties props;
        private Object[] instances;
        private String profile;
        private Consumer<String> loggerF;
        private boolean dynamicMethodFlag;
        private Map<String, String> overriddenAliases;

        public Builder setDependencyProviders(Object ... dependencyProviders) {
            for (Object dp : dependencyProviders) {
                if (!Arrays.stream(dp.getClass().getDeclaredMethods()).noneMatch(m -> m.isAnnotationPresent(DependencyProvider.class) || m.isAnnotationPresent(Constant.class))) continue;
                throw new IllegalArgumentException("Invalid Dependency Provider '" + dp.getClass().getName() + "'! No method in this class is annotated with @DependencyProvider.");
            }
            this.providers = dependencyProviders;
            return this;
        }

        public Builder setBasePackages(String ... packages) {
            this.packages = packages;
            return this;
        }

        public Builder setProperties(Properties props) {
            this.props = props;
            return this;
        }

        public Builder setDependencyInstances(Object ... instances) {
            this.instances = instances;
            return this;
        }

        public Builder setProfile(String profile) {
            boolean isEmpty;
            boolean bl = isEmpty = profile == null || profile.isEmpty();
            if (isEmpty) {
                System.out.println("WARNING: Profile passed as '' (empty). This is same as resolving dependencies WITHOUT profile!");
            } else {
                this.profile = profile;
            }
            return this;
        }

        public Builder setLoggerF(Consumer<String> loggerF) {
            this.loggerF = loggerF;
            return this;
        }

        public Builder withDynamicMethods() {
            return this.withDynamicMethods(Collections.emptyMap());
        }

        public Builder withDynamicMethods(Map<String, String> overriddenAliases) {
            this.overriddenAliases = overriddenAliases;
            this.dynamicMethodFlag = true;
            return this;
        }

        public DependencyResolverConfig build() {
            return new DependencyResolverConfig(this.providers, this.packages, this.props, this.instances, this.profile, this.loggerF, this.dynamicMethodFlag, this.overriddenAliases);
        }
    }
}

