/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.di.core;

import com.simplj.di.core.DependencyResolver;
import com.simplj.di.core.DependencyResolverConfig;
import com.simplj.di.exceptions.SdfException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DependencyResolverFactory {
    private static final DependencyResolverFactory instance = new DependencyResolverFactory();
    private static final String DEFAULT_CONTEXT = "default";
    private final Map<String, DependencyResolver> resolvers = new ConcurrentHashMap<String, DependencyResolver>();

    private DependencyResolverFactory() {
    }

    public static DependencyResolver defaultResolver() {
        return DependencyResolverFactory.resolver(DEFAULT_CONTEXT);
    }

    public static DependencyResolver resolver(String context) {
        DependencyResolver resolver = DependencyResolverFactory.instance.resolvers.get(context);
        if (resolver == null) {
            throw new SdfException("DependencyResolver not found for '" + context + "' context!");
        }
        return resolver;
    }

    public static void configureDefaultResolver(DependencyResolverConfig config) {
        DependencyResolverFactory.configureResolver(DEFAULT_CONTEXT, config);
    }

    public static void configureResolver(String context, DependencyResolverConfig config) {
        DependencyResolver resolver = new DependencyResolver();
        DependencyResolver existing = DependencyResolverFactory.instance.resolvers.putIfAbsent(context, resolver);
        if (existing == null) {
            resolver.setup(context, config);
        } else {
            System.out.println("WARN: A resolver is already configured for '" + context + "' context!");
        }
    }
}

