/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.di.internal;

import com.simplj.di.internal.CType;
import com.simplj.di.internal.Kind;
import com.simplj.di.internal.PType;
import com.simplj.di.internal.TypeRef;
import com.simplj.di.internal.UBType;
import com.simplj.di.internal.VType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

class BType
extends TypeRef {
    private final String name;
    private final List<TypeRef> types;
    private final List<TypeRef> parents;
    private final Set<String> vTypes;
    private String typedName;
    private String rawName;

    BType(Type rawType, String name, List<TypeRef> types) {
        super(rawType);
        this.name = name;
        this.types = types;
        this.parents = types.isEmpty() ? Collections.emptyList() : types.stream().flatMap(t -> t.parents().stream()).collect(Collectors.toList());
        this.vTypes = types.isEmpty() ? Collections.emptySet() : types.stream().flatMap(t -> t.vTypes().stream()).collect(Collectors.toSet());
        this.typedName = types.stream().map(TypeRef::typedName).collect(Collectors.joining(" & "));
        this.rawName = types.stream().map(TypeRef::rawName).collect(Collectors.joining(" & "));
    }

    List<TypeRef> getTypes() {
        return this.types;
    }

    @Override
    public boolean isAssignableFrom(TypeRef ref) {
        boolean res = false;
        if (ref != null) {
            switch (ref.kind()) {
                case Concrete: {
                    CType cType = (CType)ref;
                    res = this.types.stream().allMatch(t -> t.isAssignableFrom(cType));
                    break;
                }
                case Parameterized: {
                    PType pType = (PType)ref;
                    res = this.types.stream().allMatch(t -> t.isAssignableFrom(pType));
                    break;
                }
                case Bounded: {
                    BType bType = (BType)ref;
                    res = this.types.size() == bType.types.size();
                    for (int i = 0; res && i < this.types.size(); ++i) {
                        res = this.types.get(i).isAssignableFrom(bType.types.get(i));
                    }
                    break;
                }
                case UpperBounded: {
                    UBType ubType = (UBType)ref;
                    res = this.types.size() == ubType.getTypes().size();
                    for (int i = 0; res && i < this.types.size(); ++i) {
                        res = this.types.get(i).isAssignableFrom(ubType.getTypes().get(i));
                    }
                    break;
                }
                case Variable: {
                    VType vType = (VType)ref;
                    res = vType.isTyped() && this.isAssignableFrom(vType.getType());
                }
            }
        }
        return res;
    }

    @Override
    List<TypeRef> parents() {
        return this.parents;
    }

    @Override
    Set<String> vTypes() {
        return this.vTypes;
    }

    @Override
    void updateVTypesFrom(TypeRef ref, Map<String, TypeRef> accumulator) {
        BType bType = ref.getAsBType();
        if (bType != null && this.types.size() == bType.types.size()) {
            for (int i = 0; i < this.types.size(); ++i) {
                this.types.get(i).updateVTypesFrom(bType.types.get(i), accumulator);
            }
        }
        this.typedName = this.types.stream().map(TypeRef::typedName).collect(Collectors.joining(" & "));
        this.rawName = this.types.stream().map(TypeRef::rawName).collect(Collectors.joining(" & "));
    }

    @Override
    void updateVTypes(Map<String, TypeRef> varTypeMap) {
        for (TypeRef type : this.types) {
            type.updateVTypes(varTypeMap);
        }
        this.typedName = this.types.stream().map(TypeRef::typedName).collect(Collectors.joining(" & "));
        this.rawName = this.types.stream().map(TypeRef::rawName).collect(Collectors.joining(" & "));
    }

    @Override
    boolean isTyped() {
        return this.types.stream().allMatch(TypeRef::isTyped);
    }

    @Override
    Kind kind() {
        return Kind.Bounded;
    }

    @Override
    public String name() {
        return String.format("%s extends %s", this.name, this.typedName);
    }

    @Override
    public String rawName() {
        return this.rawName;
    }

    @Override
    public String typedName() {
        return this.typedName;
    }

    String varName() {
        return this.name;
    }
}

