/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.di.internal;

import com.simplj.di.exceptions.SdfException;
import com.simplj.di.internal.DependencyDef;
import com.simplj.di.internal.ParameterMeta;
import com.simplj.di.internal.TypeUtil;
import java.lang.reflect.Parameter;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;

final class CommonUtil {
    CommonUtil() {
    }

    static boolean isEmpty(String val) {
        boolean isEmpty;
        boolean bl = isEmpty = null == val;
        if (!isEmpty) {
            isEmpty = true;
            char[] chars = val.toCharArray();
            for (int i = 0; i < chars.length && isEmpty; ++i) {
                isEmpty = chars[i] == ' ';
            }
        }
        return isEmpty;
    }

    static boolean isNotEmpty(String val) {
        return !CommonUtil.isEmpty(val);
    }

    static <T> boolean isEmpty(T[] arr) {
        return arr == null || arr.length == 0;
    }

    static <T> boolean isEmpty(Collection<T> arr) {
        return arr == null || arr.size() == 0;
    }

    static Object getRealtimeParam(Map<String, Object> rtParams, Function<String, DependencyDef> depF, ParameterMeta rtp, String type) {
        Object temp;
        if (rtp.isSubstituted()) {
            temp = rtParams.get(rtp.key());
            if (null != temp) {
                if (!(temp instanceof String)) {
                    throw new SdfException("Substitution Failed! Value for a @Realtime key must be of type 'java.lang.String'. " + rtp.key() + " substitution has type " + temp.getClass().getName());
                }
                DependencyDef dd = depF.apply(temp.toString());
                if (dd == null) {
                    throw new SdfException("No Instance found for id '" + temp + "' - derived from " + rtp.substitutedFrom() + '!');
                }
                temp = dd.instantiate(rtParams, depF);
            } else if (!rtp.isNullable()) {
                throw new SdfException("@Realtime key '" + rtp.key() + "' substituted to `null`. a NonNull String value is expected here!");
            }
        } else {
            temp = rtParams.get(rtp.key());
        }
        if (temp == null && !rtp.isNullable()) {
            throw new SdfException(type + "'! Reason: Could not find not-nullable dependency [" + rtp.key() + "]. Hint: Mark the parameter as `nullable=true` if optional.");
        }
        return TypeUtil.typeCast(rtp.type(), temp);
    }

    static void validateNullable(String srcClass, boolean isNullable, Parameter parameter) {
        if (isNullable && parameter.getType().isPrimitive()) {
            throw new SdfException("primitive type " + parameter.getType().getName() + " in class '" + srcClass + "' cannot be nullable!");
        }
    }

    static String tagMsg(String tag) {
        return (CommonUtil.isEmpty(tag) ? "" : " with tag '" + tag + '\'') + "! Hint: verify if correct tag or profile or context is used.";
    }
}

