/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.di.internal;

import com.simplj.di.annotations.Dependency;
import com.simplj.di.annotations.DependencyProvider;
import com.simplj.di.exceptions.SdfException;
import com.simplj.di.internal.CommonUtil;
import com.simplj.di.internal.DependencyArg;
import com.simplj.di.internal.DependencyInstantiator;
import com.simplj.di.internal.TypeRef;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

final class DependencyDef {
    private final String id;
    private final String name;
    private final TypeRef typeRef;
    private final DependencyInstantiator instantiator;
    private final boolean isSingleton;
    private final boolean isDefault;
    private final String fullyQualifiedName;
    private final Set<String> tags;
    private final boolean isConstant;
    private final boolean isProvider;
    private final boolean isDependency;
    private final Map<Integer, DependencyArg> dependencies;
    private final String profile;
    private boolean isRealtime;

    static DependencyDef newDependency(TypeRef typeRef, DependencyInstantiator instantiator, String fullyQualifiedName, Dependency annotation, String profile) {
        Set<String> tags = Arrays.stream(annotation.tags()).filter(CommonUtil::isNotEmpty).collect(Collectors.toSet());
        return new DependencyDef(annotation.id(), typeRef.name(), typeRef, instantiator, annotation.singleton(), annotation.isDefault(), fullyQualifiedName, false, false, new HashMap<Integer, DependencyArg>(), tags, profile);
    }

    static DependencyDef newDependencyProvider(TypeRef typeRef, DependencyInstantiator instantiator, String fullyQualifiedName, DependencyProvider annotation, String profile) {
        Set<String> tags = Arrays.stream(annotation.tags()).filter(CommonUtil::isNotEmpty).collect(Collectors.toSet());
        return new DependencyDef(annotation.id(), typeRef.name(), typeRef, instantiator, annotation.singleton(), annotation.isDefault(), fullyQualifiedName, false, true, new HashMap<Integer, DependencyArg>(), tags, profile);
    }

    static DependencyDef newConstant(String constantId, TypeRef typeRef, DependencyInstantiator instantiator, String fullyQualifiedName, String[] tags, String profile) {
        Set<String> ts = tags == null ? Collections.emptySet() : Arrays.stream(tags).filter(CommonUtil::isNotEmpty).collect(Collectors.toSet());
        return new DependencyDef(constantId, constantId, typeRef, instantiator, false, false, fullyQualifiedName, true, false, new HashMap<Integer, DependencyArg>(), ts, profile);
    }

    static DependencyDef newDependencyInstance(TypeRef typeRef, DependencyInstantiator instantiator, String fullyQualifiedName) {
        return new DependencyDef(null, typeRef.name(), typeRef, instantiator, true, false, fullyQualifiedName, false, false, Collections.emptyMap(), Collections.emptySet(), "");
    }

    private DependencyDef(String id, String name, TypeRef typeRef, DependencyInstantiator instantiator, boolean isSingleton, boolean isDefault, String fullyQualifiedName, boolean isConstant, boolean isProvider, Map<Integer, DependencyArg> arguments, Set<String> tags, String profile) {
        this.id = id == null ? null : id.trim();
        this.name = name == null ? null : name.trim();
        this.typeRef = typeRef;
        this.instantiator = instantiator;
        this.isSingleton = isSingleton;
        this.isDefault = isDefault;
        this.fullyQualifiedName = fullyQualifiedName;
        this.tags = tags;
        this.isConstant = isConstant;
        this.isProvider = isProvider;
        this.isDependency = !isConstant && !isProvider;
        this.dependencies = arguments;
        this.profile = profile;
    }

    void addArgument(int idx, DependencyArg arg) throws SdfException {
        this.dependencies.put(idx, arg);
        this.isRealtime = this.isRealtime || arg.isRealtime();
    }

    DependencyDef updateVTypes(Map<String, TypeRef> vTypeMap) {
        this.typeRef.updateVTypes(vTypeMap);
        DependencyDef res = new DependencyDef(this.id, this.typeRef.name(), this.typeRef, this.instantiator, this.isSingleton, this.isDefault, this.fullyQualifiedName, this.isConstant, this.isProvider, this.dependencies, this.tags, this.profile);
        res.isRealtime = this.isRealtime;
        return res;
    }

    String getId() {
        return this.id;
    }

    String getName() {
        return this.name;
    }

    TypeRef getTypeRef() {
        return this.typeRef;
    }

    DependencyInstantiator getInstantiator() {
        return this.instantiator;
    }

    boolean isSingleton() {
        return this.isSingleton;
    }

    boolean isDefault() {
        return this.isDefault;
    }

    String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    Set<String> getTags() {
        return this.tags;
    }

    public String profile() {
        return this.profile;
    }

    boolean matchesTag(String tag) {
        boolean emptyTag = CommonUtil.isEmpty(tag);
        return emptyTag && this.tags.isEmpty() || !emptyTag && this.tags.contains(tag);
    }

    boolean isConstant() {
        return this.isConstant;
    }

    boolean isProvider() {
        return this.isProvider;
    }

    boolean isDependency() {
        return this.isDependency;
    }

    boolean isRealtime() {
        return this.isRealtime;
    }

    Map<Integer, DependencyArg> getDependencies() {
        return this.dependencies;
    }

    Object instantiate(Class<?> type) {
        return this.instantiator.instantiate(type);
    }

    Object instantiate() {
        return this.instantiator.instantiate();
    }

    Object instantiate(Map<String, Object> rtParams, Function<String, DependencyDef> depF) {
        return this.instantiator.instantiate(rtParams, depF);
    }

    public String toString() {
        return "DD{" + (CommonUtil.isEmpty(this.id) ? "" : this.id + "::") + this.typeRef + ", " + this.fullyQualifiedName + (this.isSingleton ? ", singleton" : "") + (this.isDefault ? ", default" : "") + (this.isConstant ? ", constant" : "") + (this.isProvider ? ", provider" : "") + (this.isDependency ? ", dependency" : "") + (this.isRealtime ? ", Realtime" : "") + '}';
    }
}

