/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.di.internal;

import com.simplj.di.exceptions.SdfException;
import com.simplj.di.internal.CommonUtil;
import com.simplj.di.internal.DependencyDef;
import com.simplj.di.internal.ParameterMeta;
import com.simplj.di.internal.TypeUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

abstract class DependencyInstantiator {
    private static final String EMPTY = "";
    private Object[] args;
    private final Map<Integer, ParameterMeta> rtArgsKeyIdxMap = new HashMap<Integer, ParameterMeta>();

    DependencyInstantiator() {
    }

    abstract Class<?> type();

    abstract Object instantiate(String var1, Object[] var2) throws SdfException;

    void setArgs(Object[] args) {
        this.args = args;
        int argsLength = args.length;
        for (int i = 0; i < argsLength; ++i) {
            Object arg = args[i];
            if (!(arg instanceof ParameterMeta)) continue;
            ParameterMeta rtp = (ParameterMeta)arg;
            this.rtArgsKeyIdxMap.put(i, rtp);
        }
    }

    boolean isRealtime() {
        return !this.rtArgsKeyIdxMap.isEmpty();
    }

    <T> T instantiate(Class<T> type) throws SdfException {
        Object o = this.instantiate(EMPTY, this.args);
        return TypeUtil.typeCast(type, o);
    }

    Object instantiate() throws SdfException {
        return this.instantiate(EMPTY, this.args);
    }

    Object instantiate(Map<String, Object> rtParams, Function<String, DependencyDef> depF) throws SdfException {
        Object[] rtArgs = Arrays.copyOf(this.args, this.args.length);
        StringBuilder rtKey = new StringBuilder();
        for (Map.Entry<Integer, ParameterMeta> entry : this.rtArgsKeyIdxMap.entrySet()) {
            ParameterMeta rtp = entry.getValue();
            rtArgs[entry.getKey().intValue()] = CommonUtil.getRealtimeParam(rtParams, depF, rtp, "Failed to instantiate '" + this.type());
            rtKey.append(rtArgs[entry.getKey()]);
        }
        return this.instantiate(rtKey.toString(), rtArgs);
    }
}

