/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.di.internal;

import com.simplj.di.annotations.Dependency;
import com.simplj.di.core.AbstractLoader;
import com.simplj.di.exceptions.SdfException;
import com.simplj.di.internal.CommonUtil;
import com.simplj.di.internal.DependencyArg;
import com.simplj.di.internal.DependencyDef;
import com.simplj.di.internal.DependencyInstantiator;
import com.simplj.di.internal.DependencyUtil;
import com.simplj.di.internal.DynMethodArg;
import com.simplj.di.internal.DynMethodDef;
import com.simplj.di.internal.ParameterMeta;
import com.simplj.di.internal.Scanner;
import com.simplj.di.internal.TypeRef;
import com.simplj.di.model.Argument;
import com.simplj.di.model.DynamicMethod;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

final class DependencyLoader
extends AbstractLoader {
    private static final Object[] EMPTY_OBJ_ARRAY = new Object[0];
    private static final String[] EMPTY_STR_ARRAY = new String[0];
    private static final Properties EMPTY_PROPERTIES = new Properties();
    private static final String SDF_CONST_KEY = "sdf_consts.";
    private final String profile;
    private final String profileMessage;
    private final Consumer<String> logger;
    private final Map<String, Set<DependencyDef>> dependencyRefMap;
    private final Map<String, DynMethodDef> dynMethodMap;
    private final Function<String, DependencyDef> depF;

    private DependencyLoader(Object[] dependencyProviders, String[] basePackages, Properties properties, String profile, Object[] dependencyInstances, Consumer<String> logger, boolean dynMethodFlag, Map<String, String> overriddenAliasMap) throws SdfException {
        if (profile == null) {
            this.profile = "";
            this.profileMessage = "";
        } else {
            this.profile = profile;
            this.profileMessage = String.format(" for profile '%s'", profile);
        }
        this.logger = logger;
        this.dependencyRefMap = new HashMap<String, Set<DependencyDef>>();
        this.dynMethodMap = dynMethodFlag ? new HashMap<String, DynMethodDef>() : null;
        this.depF = v -> DependencyUtil.getDependency(v, this.dependencyRefMap);
        Object[] dp = dependencyProviders == null ? EMPTY_OBJ_ARRAY : dependencyProviders;
        String[] bp = basePackages == null ? EMPTY_STR_ARRAY : basePackages;
        Properties p = properties == null ? EMPTY_PROPERTIES : properties;
        Object[] di = dependencyInstances == null ? EMPTY_OBJ_ARRAY : dependencyInstances;
        this.init(dp, bp, p, di, overriddenAliasMap);
    }

    @Override
    protected final Object get(Type type, String tag) throws SdfException {
        TypeRef typeRef = TypeRef.fromType(type);
        DependencyDef dd = DependencyUtil.getDependency(typeRef, tag, this.dependencyRefMap);
        if (dd == null) {
            throw new SdfException("No Instance found for '" + typeRef.name() + '\'' + this.profileMessage + CommonUtil.tagMsg(tag));
        }
        if (dd.isRealtime()) {
            throw new SdfException(typeRef.rawName() + " has runtime provided dependencies and cannot be resolved through `resolve` method! Hint: Use `dynamicResolve()` with the necessary runtime parameters.");
        }
        return dd.instantiate();
    }

    @Override
    protected final Object get(Type type, String tag, Map<String, Object> rtParams) throws SdfException {
        TypeRef typeRef = TypeRef.fromType(type);
        DependencyDef di = DependencyUtil.getDependency(typeRef, tag, this.dependencyRefMap);
        if (di == null) {
            throw new SdfException("No Instance found for '" + typeRef.name() + '\'' + this.profileMessage + CommonUtil.tagMsg(tag));
        }
        return di.instantiate(rtParams, this.depF);
    }

    @Override
    protected final Object get(TypeRef typeRef, String tag, Map<String, Object> rtParams) throws SdfException {
        DependencyDef di = DependencyUtil.getDependency(typeRef, tag, this.dependencyRefMap);
        if (di == null) {
            throw new SdfException("No Instance found for '" + typeRef.name() + '\'' + this.profileMessage + CommonUtil.tagMsg(tag));
        }
        return di.instantiate(rtParams, this.depF);
    }

    @Override
    protected final Object get(String id) throws SdfException {
        DependencyDef dd = DependencyUtil.getDependency(id, this.dependencyRefMap);
        if (dd == null) {
            throw new SdfException("No Instance found for id '" + id + '\'' + this.profileMessage + '!');
        }
        if (dd.isRealtime()) {
            throw new SdfException(id + " has runtime provided dependencies and cannot be resolved through `resolve` method! Hint: Use `dynamicResolve()` with the necessary runtime parameters.");
        }
        return dd.instantiate();
    }

    @Override
    protected final Object get(String id, Map<String, Object> rtParams) throws SdfException {
        DependencyDef di = DependencyUtil.getDependency(id, this.dependencyRefMap);
        if (di == null) {
            throw new SdfException("No Instance found for id '" + id + '\'' + this.profileMessage + '!');
        }
        return di.instantiate(rtParams, this.depF);
    }

    @Override
    protected final Object invoke(String method, Object ... args) {
        return this.invoke(method, Collections.emptyMap(), args);
    }

    @Override
    protected final Object invoke(String method, Map<String, Object> rtParams, Object ... args) {
        if (null == this.dynMethodMap) {
            throw new SdfException("Dynamic Method Invocation is not configured!");
        }
        DynMethodDef md = Optional.ofNullable(this.dynMethodMap.get(method)).orElseThrow(() -> new SdfException("Dynamic method '" + method + "' not found!"));
        return md.invoke(rtParams, args, this.depF);
    }

    @Override
    protected final Map<String, DynamicMethod> getDynamicMethods() {
        Map<String, DynamicMethod> res;
        if (null == this.dynMethodMap) {
            res = Collections.emptyMap();
        } else {
            res = new HashMap();
            for (Map.Entry<String, DynMethodDef> e : this.dynMethodMap.entrySet()) {
                res.put(e.getKey(), new DynamicMethod(e.getValue().clazz(), e.getValue().methodName(), e.getValue().returnType(), e.getValue().description(), this.labelVsTypeMap(e)));
            }
        }
        return res;
    }

    private List<Argument> labelVsTypeMap(Map.Entry<String, DynMethodDef> e) {
        LinkedList<Argument> res = new LinkedList<Argument>();
        TypeRef str = TypeRef.fromClass(String.class);
        for (DynMethodArg a : e.getValue().getIdxArgMap().values()) {
            if (a.isRealtimeArg()) {
                res.add(new Argument(Optional.ofNullable(a.label()).orElse("arg#" + a.getIndex()), a.getTypeRef().name(), a.getTypeRef(), false));
                continue;
            }
            if (!a.isRealtimeParam()) continue;
            ParameterMeta pm = a.getRealtimeParamMeta();
            if (pm.isSubstituted()) {
                res.add(new Argument(Optional.ofNullable(a.label()).orElse("arg#" + a.getIndex()), str.name(), str, pm.isNullable()));
                continue;
            }
            res.add(new Argument(Optional.ofNullable(a.label()).orElse("arg#" + a.getIndex()), a.getTypeRef().name(), a.getTypeRef(), pm.isNullable()));
        }
        return res;
    }

    private void init(Object[] dependencyProviders, String[] basePackages, Properties properties, Object[] dependencyInstances, Map<String, String> overriddenAliasMap) throws SdfException {
        long start = System.currentTimeMillis();
        this.logger.accept(" - SDF: Analyzing dependencies...");
        HashMap<String, Set<String>> dynMethodErrors = new HashMap<String, Set<String>>();
        this.loadDependencies(this.dependencyRefMap, this.dynMethodMap, dependencyInstances, dependencyProviders, basePackages, properties, overriddenAliasMap, dynMethodErrors);
        this.logger.accept(" - SDF: Analysis done. No CircularDependency or MissingDependency found! Instantiating...");
        HashSet<String> initializedDeps = new HashSet<String>();
        int size = 0;
        for (Set<DependencyDef> set : this.dependencyRefMap.values()) {
            for (DependencyDef d : set) {
                if (initializedDeps.contains(d.getName()) && (CommonUtil.isEmpty(d.getId()) || initializedDeps.contains(d.getId()))) continue;
                this.initialize(d, this.dependencyRefMap, initializedDeps);
                ++size;
            }
        }
        if (!dynMethodErrors.isEmpty()) {
            dynMethodErrors.forEach((k, v) -> this.logger.accept("[ERROR] Dynamic method '" + k + "' found in multiple classes: " + v + '!' + System.lineSeparator() + " - Hint: Either alias can be added for the method in the classes or following overridden alias can be configured in 'sjf.<canonicalClassName>.<targetMethodOrAliasName>.alias=<alias>' format:" + System.lineSeparator() + v.stream().map(c -> String.format("\tsjf.%s.%s.alias=<alias>", c, k)).collect(Collectors.joining(System.lineSeparator()))));
            throw new SdfException("Dynamic method names must be unique or configured with alias for uniqueness!");
        }
        String text = "";
        if (null != this.dynMethodMap) {
            for (DynMethodDef d : this.dynMethodMap.values()) {
                this.initialize(d, this.dependencyRefMap, initializedDeps);
                ++size;
            }
            text = "/dynamicMethods";
        }
        this.logger.accept(" - SDF: Dependencies " + (this.profile.isEmpty() ? "" : "with Profile '" + this.profile + "' ") + "Instantiated Successfully!");
        long l = System.currentTimeMillis();
        this.logger.accept(" - SDF: Initialized with " + size + " dependencies/constants" + text + " in " + this.formatTime(l - start));
    }

    private String formatTime(long millis) {
        return (double)millis / 1000.0 + " sec(s)";
    }

    private void printMaps(int n, String prefix) {
        if ((n & 1) == 1) {
            this.logger.accept("RefMap:");
            this.dependencyRefMap.forEach((k, v) -> {
                if (prefix == null || k.startsWith(prefix)) {
                    this.logger.accept(k + " ->\n\t" + v.stream().map(DependencyDef::toString).collect(Collectors.joining("\n\t")));
                }
            });
        }
        if (null != this.dynMethodMap) {
            this.dynMethodMap.forEach((k, v) -> System.out.println(k + ": " + v));
        }
    }

    private void loadDependencies(Map<String, Set<DependencyDef>> refMap, Map<String, DynMethodDef> mRefMap, Object[] dependencyInstances, Object[] dependencyProviders, String[] basePackages, Properties properties, Map<String, String> overriddenAliasMap, Map<String, Set<String>> dynMethodErrors) throws SdfException {
        this.loadConstants(refMap, dependencyProviders, properties);
        LinkedList<DependencyDef> idBoundGenDeps = new LinkedList<DependencyDef>();
        HashSet<String> depDirectRefs = new HashSet<String>();
        for (Object instance : dependencyInstances) {
            DependencyUtil.loadDependencyInstance(instance, instance.getClass(), refMap, mRefMap, idBoundGenDeps, depDirectRefs, this.profile, overriddenAliasMap, dynMethodErrors);
        }
        DependencyUtil.loadDependencyProviders(dependencyProviders, mRefMap, refMap, idBoundGenDeps, depDirectRefs, this.profile, overriddenAliasMap, dynMethodErrors);
        for (String p : basePackages) {
            Set<Class<?>> deps = Scanner.scanForAnnotatedClasses(p, Dependency.class);
            DependencyUtil.loadDependencies(deps, refMap, mRefMap, idBoundGenDeps, depDirectRefs, this.profile, overriddenAliasMap, dynMethodErrors);
        }
        DependencyUtil.enrichIdBoundGenDeps(idBoundGenDeps, refMap, depDirectRefs);
        DependencyUtil.validateAndCleanupLoadedDependencies(refMap, depDirectRefs, this.profile);
    }

    private void loadConstants(Map<String, Set<DependencyDef>> depMap, Object[] dependencyProviders, Properties properties) throws SdfException {
        for (String k : System.getProperties().stringPropertyNames()) {
            if (!k.startsWith(SDF_CONST_KEY)) continue;
            properties.setProperty(k.substring(SDF_CONST_KEY.length()), System.getProperty(k));
        }
        DependencyUtil.loadConstantProviders(properties, dependencyProviders, depMap, this.profile);
    }

    private void initialize(DependencyDef d, Map<String, Set<DependencyDef>> refMap, Set<String> initializedDeps) throws SdfException {
        Collection<DependencyArg> deps = d.getDependencies().values();
        Object[] args = new Object[deps.size()];
        for (DependencyArg a : deps) {
            DependencyDef dep;
            if (a.isRealtime()) {
                args[a.getIndex()] = a.getRealtimeMeta();
                continue;
            }
            if (a.isSubTypes()) {
                Set<DependencyDef> subTypes = DependencyUtil.getSubTypes(o -> !d.equals(o), a.getTypeRef(), a.getTag(), refMap);
                for (DependencyDef st : subTypes) {
                    if (initializedDeps.contains(st.getName()) && (CommonUtil.isEmpty(st.getId()) || initializedDeps.contains(st.getId()))) continue;
                    this.initialize(st, refMap, initializedDeps);
                }
                args[a.getIndex()] = DependencyUtil.populateSubTypeArgs(a.getSubTypesMeta(), subTypes);
                continue;
            }
            DependencyDef dependencyDef = dep = a.isIdBound() ? DependencyUtil.getDependency(a.getTypeNameOrId(), refMap) : DependencyUtil.getDependency(a.getTypeRef(), a.getTag(), refMap);
            if (!initializedDeps.contains(dep.getName()) || !CommonUtil.isEmpty(dep.getId()) && !initializedDeps.contains(dep.getId())) {
                this.initialize(dep, refMap, initializedDeps);
            }
            args[a.getIndex()] = dep.instantiate(a.getType());
        }
        DependencyInstantiator dInit = d.getInstantiator();
        dInit.setArgs(args);
        initializedDeps.add(d.getName());
        if (!CommonUtil.isEmpty(d.getId())) {
            initializedDeps.add(d.getId());
        }
    }

    private void initialize(DynMethodDef d, Map<String, Set<DependencyDef>> refMap, Set<String> initializedDeps) throws SdfException {
        Collection<DynMethodArg> args = d.getIdxArgMap().values();
        for (DynMethodArg a : args) {
            DependencyDef dep;
            if (a.isSubTypes()) {
                Set<DependencyDef> subTypes = DependencyUtil.getSubTypes(x -> true, a.getTypeRef(), a.getTag(), refMap);
                for (DependencyDef st : subTypes) {
                    if (initializedDeps.contains(st.getName()) && (CommonUtil.isEmpty(st.getId()) || initializedDeps.contains(st.getId()))) continue;
                    this.initialize(st, refMap, initializedDeps);
                }
                a.setSubTypeVal(DependencyUtil.populateSubTypeArgs(a.getSubTypesMeta(), subTypes));
                continue;
            }
            if (!a.isImplicit()) continue;
            DependencyDef dependencyDef = dep = a.isIdBound() ? DependencyUtil.getDependency(a.getTypeNameOrId(), refMap) : DependencyUtil.getDependency(a.getTypeRef(), a.getTag(), refMap);
            if (dep == null) {
                String msg = a.isIdBound() ? "id '" + a.getTypeNameOrId() + "'!" : " type '" + a.getTypeRef().name() + "'!";
                throw new SdfException("No Instance found for " + msg);
            }
            a.setImplicitInstantiator(dep.getInstantiator());
        }
    }
}

