/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.di.internal;

import com.simplj.di.annotations.Constant;
import com.simplj.di.annotations.Dependency;
import com.simplj.di.annotations.DependencyProvider;
import com.simplj.di.annotations.DynamicInvocation;
import com.simplj.di.exceptions.CircularDependencyException;
import com.simplj.di.exceptions.SdfException;
import com.simplj.di.internal.AType;
import com.simplj.di.internal.CommonUtil;
import com.simplj.di.internal.ConstantInstantiator;
import com.simplj.di.internal.ConstructorInstantiator;
import com.simplj.di.internal.DependencyArg;
import com.simplj.di.internal.DependencyDef;
import com.simplj.di.internal.DependencyInstantiator;
import com.simplj.di.internal.DynMethodArg;
import com.simplj.di.internal.DynMethodDef;
import com.simplj.di.internal.GAType;
import com.simplj.di.internal.MethodInstantiator;
import com.simplj.di.internal.ParameterMeta;
import com.simplj.di.internal.SingletonInstantiator;
import com.simplj.di.internal.TypeRef;
import com.simplj.di.internal.TypeUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;

final class DependencyUtil {
    DependencyUtil() {
    }

    static DependencyDef getDependency(TypeRef type, String tag, Map<String, Set<DependencyDef>> refMap) throws SdfException {
        DependencyDef res = null;
        Set deps = refMap.getOrDefault(type.typedName(), refMap.getOrDefault(type.rawName(), Collections.emptySet())).stream().filter(d -> type.isAssignableFrom(d.getTypeRef()) && d.matchesTag(tag)).collect(Collectors.toSet());
        if (deps.size() == 1) {
            res = (DependencyDef)DependencyUtil.firstItem(deps);
        } else if (deps.size() > 1) {
            List defaults = deps.stream().filter(DependencyDef::isDefault).collect(Collectors.toList());
            if (defaults.isEmpty()) {
                throw new SdfException("Multiple implementations found for '" + type.name() + '\'' + (CommonUtil.isEmpty(tag) ? "" : " with tag '" + tag + '\'') + ": [" + deps.stream().map(d -> d.isProvider() ? d.getFullyQualifiedName() : d.getName()).collect(Collectors.joining(", ")) + "]");
            }
            if (defaults.size() > 1) {
                throw new SdfException("Multiple default implementations found for '" + type.name() + '\'' + (CommonUtil.isEmpty(tag) ? "" : " with tag '" + tag + '\'') + ": [" + defaults.stream().map(d -> d.isProvider() ? d.getFullyQualifiedName() : d.getName()).collect(Collectors.joining(", ")) + "]");
            }
            res = (DependencyDef)defaults.get(0);
        }
        return res;
    }

    static DependencyDef getDependency(String id, Map<String, Set<DependencyDef>> refMap) throws SdfException {
        DependencyDef res = null;
        Set<DependencyDef> ds = refMap.get(id);
        if (ds != null && ds.size() == 1) {
            res = DependencyUtil.firstItem(ds);
        }
        return res;
    }

    static Set<DependencyDef> getSubTypes(Function<DependencyDef, Boolean> filterCondition, TypeRef type, String tag, Map<String, Set<DependencyDef>> refMap) {
        return refMap.getOrDefault(type.rawName(), Collections.emptySet()).stream().filter(d -> type.isAssignableFrom(d.getTypeRef()) && d.matchesTag(tag) && (Boolean)filterCondition.apply((DependencyDef)d) != false).collect(Collectors.toSet());
    }

    static Object populateSubTypeArgs(ParameterMeta m, Set<DependencyDef> subTypes) throws SdfException {
        LinkedList<Object> resList = null;
        HashMap<String, Object> resMap = null;
        if (m.type().equals(Map.class)) {
            resMap = new HashMap<String, Object>();
        } else if (m.type().equals(List.class)) {
            resList = new LinkedList<Object>();
        } else {
            throw new SdfException("Only `Map` or `List` type is supported to have @SubTypes annotation!");
        }
        for (DependencyDef d : subTypes) {
            Object temp = d.instantiate();
            if (temp == null) continue;
            if (resList != null) {
                resList.add(temp);
                continue;
            }
            resMap.put(CommonUtil.isEmpty(d.getId()) ? d.getName() : d.getId(), temp);
        }
        return resList == null ? resMap : resList;
    }

    static void enrichIdBoundGenDeps(List<DependencyDef> idBoundGenDeps, Map<String, Set<DependencyDef>> refMap, Set<String> depDirectRefs) {
        for (DependencyDef d : idBoundGenDeps) {
            DependencyUtil.enrichIdBoundGenDep(d, refMap, depDirectRefs);
        }
    }

    private static void enrichIdBoundGenDep(DependencyDef d, Map<String, Set<DependencyDef>> refMap, Set<String> depDirectRefs) {
        if (d.getTypeRef().isTyped()) {
            return;
        }
        HashMap<String, TypeRef> vTypeMap = new HashMap<String, TypeRef>();
        for (DependencyArg a : d.getDependencies().values()) {
            if (!a.isIdBound() || a.getTypeRef().vTypes().isEmpty()) continue;
            DependencyDef ad = DependencyUtil.getDependency(a.getTypeNameOrId(), refMap);
            if (ad == null) {
                throw new SdfException("Could not load class " + d.getName() + ". Missing dependency '" + a.getTypeNameOrId() + (a.isSubstituted() ? "' - derived from " + a.getSubstitutedFrom() : "'") + CommonUtil.tagMsg(a.getTag()));
            }
            if (!ad.getTypeRef().isTyped()) {
                DependencyUtil.enrichIdBoundGenDep(ad, refMap, depDirectRefs);
            }
            a.updateVTypesFrom(ad.getTypeRef(), vTypeMap);
        }
        d = d.updateVTypes(vTypeMap);
        DependencyUtil.registerDependency(refMap, Collections.emptyList(), d.getTypeRef(), d, false, true, depDirectRefs);
    }

    static void validateAndCleanupLoadedDependencies(Map<String, Set<DependencyDef>> refMap, Set<String> depDirectRefs, String profile) throws SdfException {
        HashSet<String> validated = new HashSet<String>();
        HashSet<String> path = new HashSet<String>();
        Iterator<Map.Entry<String, Set<DependencyDef>>> iter = refMap.entrySet().iterator();
        HashMap<String, Set<DependencyDef>> profileDependencies = new HashMap<String, Set<DependencyDef>>();
        HashMap<String, Map> defaultsMap = new HashMap<String, Map>();
        HashMap<String, Map> nonDefaultsMap = new HashMap<String, Map>();
        LinkedList<String> defaults = new LinkedList<String>();
        LinkedList<String> nonDefaults = new LinkedList<String>();
        StringBuilder errors = new StringBuilder();
        HashMap<String, Map> typeVsIdImplMap = new HashMap<String, Map>();
        AtomicInteger ai = new AtomicInteger();
        while (iter.hasNext()) {
            Map.Entry<String, Set<DependencyDef>> entry = iter.next();
            DependencyUtil.filterProfileDependencies(profile, entry, profileDependencies);
            boolean isMultiple = entry.getValue().size() > 1;
            for (DependencyDef d : entry.getValue()) {
                DependencyUtil.validateDependency(d, refMap, path, validated);
                path.clear();
                if (!depDirectRefs.contains(entry.getKey())) continue;
                if (isMultiple) {
                    typeVsIdImplMap.computeIfAbsent(d.getName(), x -> new HashMap()).computeIfAbsent(Optional.ofNullable(d.getId()).orElse(""), x -> new HashSet()).add(d.getFullyQualifiedName());
                }
                if (d.isDefault()) {
                    if (d.getTags().isEmpty()) {
                        defaults.add(d.getFullyQualifiedName());
                    }
                    for (String t2 : d.getTags()) {
                        defaultsMap.computeIfAbsent(t2, x -> new HashMap()).computeIfAbsent(entry.getKey(), x -> new LinkedList()).add(d.getFullyQualifiedName());
                    }
                    continue;
                }
                if (d.getTags().isEmpty()) {
                    nonDefaults.add(d.getFullyQualifiedName());
                }
                for (String t2 : d.getTags()) {
                    nonDefaultsMap.computeIfAbsent(t2, x -> new HashMap()).computeIfAbsent(entry.getKey(), x -> new LinkedList()).add(d.getFullyQualifiedName());
                }
            }
            if (defaults.size() > 1) {
                errors.append("\n\t").append(ai.incrementAndGet()).append(". Multiple implementations for '").append(entry.getKey()).append("' exists ").append(defaults).append(" and are marked as default");
            }
            if (defaults.size() == 0 && nonDefaults.size() > 1) {
                errors.append("\n\t").append(ai.incrementAndGet()).append(". Multiple implementations for '").append(entry.getKey()).append("' exists ").append(nonDefaults).append(" and none is marked as default");
            }
            nonDefaults.clear();
            defaults.clear();
        }
        typeVsIdImplMap.forEach((t, m) -> {
            Set nonIds = m.getOrDefault("", Collections.emptySet());
            if (nonIds.size() > 1) {
                errors.append("\n\t").append(ai.incrementAndGet()).append(". Multiple implementations for a same type must have `id`! ").append(nonIds).append(" do not have any id associated.");
            } else if (nonIds.size() == 1 && m.size() > 1) {
                errors.append("\n\t").append(ai.incrementAndGet()).append(". Multiple implementations for a same type must have `id`! ").append(nonIds).append(" does not have any id associated.");
            }
        });
        defaultsMap.forEach((t, m) -> m.forEach((k, v) -> {
            if (v.size() > 1) {
                errors.append("\n\t").append(ai.incrementAndGet()).append(". Multiple implementations for '").append((String)k).append('\'').append(" with tag '").append((String)t).append("' exists ").append(defaults).append(" and are marked as default");
            }
        }));
        nonDefaultsMap.forEach((t, m) -> m.forEach((k, v) -> {
            if (v.size() > 1) {
                errors.append("\n\t").append(ai.incrementAndGet()).append(". Multiple implementations for '").append((String)k).append('\'').append(" with tag '").append((String)t).append("' exists ").append(nonDefaults).append(" and none is marked as default");
            }
        }));
        if (errors.length() > 0) {
            throw new SdfException("Found following multiple instances for same type!\n\t* Even in case of multiple implementations with `id`, one must be marked as `default` so that no ambiguity is detected while resolving without id." + errors);
        }
        profileDependencies.forEach(refMap::put);
    }

    private static void validateDependency(DependencyDef d, Map<String, Set<DependencyDef>> refMap, Set<String> path, Set<String> validated) throws SdfException {
        String className = d.getName();
        if (!validated.contains(className)) {
            if (path.contains(className)) {
                throw new CircularDependencyException(className);
            }
            Collection<DependencyArg> dependencies = d.getDependencies().values();
            path.add(className);
            for (DependencyArg a : dependencies) {
                if (a.isRealtime()) continue;
                if (a.isSubTypes()) {
                    DependencyUtil.validateSubTypeDependency(d, refMap, path, validated, className, a);
                    continue;
                }
                DependencyUtil.validateArgDependency(d, refMap, path, validated, className, a);
            }
            validated.add(className);
            path.remove(className);
        }
    }

    private static void validateArgDependency(DependencyDef d, Map<String, Set<DependencyDef>> refMap, Set<String> path, Set<String> validated, String className, DependencyArg a) {
        DependencyDef subD;
        DependencyDef dependencyDef = subD = a.isIdBound() ? DependencyUtil.getDependency(a.getTypeNameOrId(), refMap) : DependencyUtil.getDependency(a.getTypeRef(), a.getTag(), refMap);
        if (subD == null) {
            throw new SdfException("Could not load class " + className + ". Missing dependency '" + a.getTypeNameOrId() + (a.isSubstituted() ? " - derived from " + a.getSubstitutedFrom() : "'") + CommonUtil.tagMsg(a.getTag()));
        }
        if (subD.isRealtime()) {
            throw new SdfException("Realtime dependencies cannot be used as a dependency! '" + d.getName() + "' has a runtime provided dependency '" + subD.getName() + "'.");
        }
        if (!(a.getTypeRef().isAssignableFrom(subD.getTypeRef()) || subD.getTypeRef().isStringClass() && TypeUtil.isPrimitiveOrWrapper(a.getTypeRef().name()))) {
            throw new SdfException("Type Mismatch! Type " + a.getTypeRef().name() + " at index " + a.getIndex() + " in class " + className + " does not match with loaded dependency " + subD.getTypeRef().name() + " for id or type: " + a.getTypeNameOrId());
        }
        try {
            DependencyUtil.validateDependency(subD, refMap, path, validated);
        }
        catch (CircularDependencyException cd) {
            throw cd.addChain(className);
        }
    }

    private static void validateSubTypeDependency(DependencyDef parent, Map<String, Set<DependencyDef>> refMap, Set<String> path, Set<String> validated, String className, DependencyArg a) {
        Set<DependencyDef> subTypes = DependencyUtil.getSubTypes(d -> !parent.equals(d), a.getTypeRef(), a.getTag(), refMap);
        if (subTypes == null) {
            if (a.getSubTypesMeta().isNullable()) {
                return;
            }
            throw new SdfException("Could not load class " + className + ". No subtypes found for '" + a.getSubTypesMeta().key() + '\'');
        }
        for (DependencyDef d2 : subTypes) {
            if (validated.contains(d2.getName())) continue;
            try {
                DependencyUtil.validateDependency(d2, refMap, path, validated);
            }
            catch (CircularDependencyException cd) {
                throw cd.addChain(className);
            }
        }
    }

    static void loadConstantProviders(Properties properties, Object[] providers, Map<String, Set<DependencyDef>> refMap, String profile) throws SdfException {
        DependencyDef d;
        for (String k : properties.stringPropertyNames()) {
            if (DependencyUtil.isVariableKey(k)) {
                throw new SdfException("Invalid constant key: " + k + "! Constant keys cannot be variable.");
            }
            d = DependencyDef.newConstant(k, TypeRef.fromClass(properties.getProperty(k).getClass()), new ConstantInstantiator(properties.getProperty(k)), k, null, "");
            refMap.put(k, Collections.singleton(d));
        }
        for (Object o : providers) {
            Method[] methods;
            Class<?> c = o.getClass();
            for (Method m : methods = c.getDeclaredMethods()) {
                if (!m.isAnnotationPresent(Constant.class)) continue;
                Constant annotation = m.getAnnotation(Constant.class);
                String fqName = c.getName() + "." + m.getName();
                int p = DependencyUtil.matchesProfile(profile, annotation.profiles(), fqName);
                if (p < 0) continue;
                Class<?> returnType = m.getReturnType();
                if (!returnType.getName().startsWith("java.lang") && !TypeUtil.isSupportedPrimitive(returnType.getTypeName())) {
                    throw new SdfException("@Constant cannot be used for type " + returnType.getName() + "! Please use @DependencyProvider instead.");
                }
                if (DependencyUtil.isVariableKey(annotation.id())) {
                    throw new SdfException("@Constant id cannot be variable key! Constant '" + fqName + "' has variable key in id.");
                }
                if (annotation.id().equals(returnType.getName()) || annotation.id().equals(returnType.getSimpleName())) {
                    throw new SdfException("@Constant id cannot be same as it's type. Erroneous @Constant declaration: " + fqName);
                }
                d = DependencyDef.newConstant(annotation.id(), TypeRef.fromMethod(m), new SingletonInstantiator(m, o), fqName, annotation.tags(), p == 1 ? profile : "");
                Set<DependencyDef> temp = refMap.get(annotation.id());
                if (null != temp) {
                    throw new SdfException("Multiple @Constant for id '" + annotation.id() + "' exists [" + d.getFullyQualifiedName() + ", " + DependencyUtil.firstItem(temp).getFullyQualifiedName() + "]");
                }
                DependencyUtil.identifyDependencies(d, m.getParameters(), refMap);
                refMap.put(annotation.id(), Collections.singleton(d));
            }
        }
    }

    static void loadDependencyProviders(Object[] providers, Map<String, DynMethodDef> mRefMap, Map<String, Set<DependencyDef>> refMap, List<DependencyDef> idBoundGenDeps, Set<String> depDirectRefs, String profile, Map<String, String> overriddenAliasMap, Map<String, Set<String>> dynMethodErrors) throws SdfException {
        for (Object o : providers) {
            Method[] methods;
            Class<?> c = o.getClass();
            for (Method m : methods = c.getDeclaredMethods()) {
                DependencyInstantiator instantiator;
                if (!m.isAnnotationPresent(DependencyProvider.class)) continue;
                DependencyProvider annotation = m.getAnnotation(DependencyProvider.class);
                String fqName = c.getName() + "." + m.getName();
                int p = DependencyUtil.matchesProfile(profile, annotation.profiles(), fqName);
                if (p < 0) continue;
                Class<?> returnType = m.getReturnType();
                if (returnType.getName().startsWith("java.lang")) {
                    throw new SdfException("@DependencyProvider cannot be used for type " + returnType.getName() + "! Please use @Constant instead.");
                }
                DependencyInstantiator dependencyInstantiator = instantiator = annotation.singleton() ? new SingletonInstantiator(m, o) : new MethodInstantiator(m, o);
                if (DependencyUtil.isVariableKey(annotation.id())) {
                    throw new SdfException("@DependencyProvider id cannot be variable key! DependencyProvider '" + fqName + "' has variable key in id.");
                }
                if (annotation.id().equals(returnType.getName()) || annotation.id().equals(returnType.getSimpleName())) {
                    throw new SdfException("@DependencyProvider id cannot be same as it's type. Erroneous @DependencyProvider declaration: " + fqName);
                }
                TypeRef typeRef = TypeRef.fromMethod(m);
                if (typeRef.kind().code() > 4) {
                    throw new SdfException("@DependencyProvider cannot have TypeVariable or Wildcard as return type");
                }
                DependencyDef d = DependencyDef.newDependencyProvider(typeRef, instantiator, fqName, annotation, p == 1 ? profile : "");
                boolean idBoundGeneric = DependencyUtil.identifyDependencies(d, m.getParameters(), refMap);
                DependencyUtil.registerDependency(refMap, idBoundGenDeps, typeRef, d, idBoundGeneric, false, depDirectRefs);
                DependencyUtil.loadDynamicMethods(profile, mRefMap, m.getReturnType(), d, refMap, overriddenAliasMap, dynMethodErrors);
            }
        }
    }

    static void loadDependencies(Set<Class<?>> classes, Map<String, Set<DependencyDef>> refMap, Map<String, DynMethodDef> mRefMap, List<DependencyDef> idBoundGenDeps, Set<String> depDirectRefs, String profile, Map<String, String> overriddenAliasMap, Map<String, Set<String>> dynMethodErrors) throws SdfException {
        for (Class<?> c : classes) {
            String fqName;
            Parameter[] params;
            DependencyInstantiator instantiator;
            if (!c.isAnnotationPresent(Dependency.class)) continue;
            if (c.isInterface() || Modifier.isAbstract(c.getModifiers())) {
                throw new SdfException("@Dependency annotation can only be used on a concrete class! '" + c.getName() + "' is an " + (c.isInterface() ? "Interface" : "Abstract Class"));
            }
            TypeRef typeRef = TypeRef.fromClass(c);
            if (typeRef.kind().code() > 4) {
                throw new SdfException("@Dependency cannot be a TypeVariable or Wildcard");
            }
            Dependency annotation = c.getAnnotation(Dependency.class);
            int p = DependencyUtil.matchesProfile(profile, annotation.profiles(), c.getName());
            if (p < 0) continue;
            if (c.getConstructors().length != 1 && annotation.initMethod().isEmpty()) {
                throw new SdfException("@Dependency classes must have only one public constructor or initMethod must be provided. " + c.getName() + " has " + c.getConstructors().length + " public constructor(s) and no initMethod provided!");
            }
            if (DependencyUtil.isVariableKey(annotation.id())) {
                throw new SdfException("@Dependency id cannot be variable key! Dependency '" + c.getName() + "' has variable key in id.");
            }
            if (!annotation.initMethod().isEmpty()) {
                Method method = DependencyUtil.findMethod(c, annotation.initMethod());
                if (!Modifier.isStatic(method.getModifiers())) {
                    throw new SdfException("@Dependency initMethod must be static. " + c.getName() + "." + method.getName() + " is not!");
                }
                instantiator = annotation.singleton() ? new SingletonInstantiator(method, null) : new MethodInstantiator(method, null);
                params = method.getParameters();
                fqName = c.getName() + "." + method.getName();
            } else {
                Constructor<?> constructor = c.getConstructors()[0];
                fqName = DependencyUtil.constructorName(constructor);
                if (!Modifier.isPublic(constructor.getModifiers())) {
                    throw new SdfException("Constructor " + fqName + " is not defined as `public` for class " + c.getName() + "!");
                }
                instantiator = annotation.singleton() ? new SingletonInstantiator(constructor) : new ConstructorInstantiator(constructor);
                params = constructor.getParameters();
            }
            if (annotation.id().equals(c.getName()) || annotation.id().equals(c.getSimpleName())) {
                throw new SdfException("@Dependency id cannot be same as it's type. Erroneous @Dependency declaration: " + c.getName());
            }
            DependencyDef d = DependencyDef.newDependency(typeRef, instantiator, fqName, annotation, p == 1 ? profile : "");
            boolean idBoundGeneric = DependencyUtil.identifyDependencies(d, params, refMap);
            DependencyUtil.registerDependency(refMap, idBoundGenDeps, typeRef, d, idBoundGeneric, false, depDirectRefs);
            DependencyUtil.loadDynamicMethods(profile, mRefMap, c, d, refMap, overriddenAliasMap, dynMethodErrors);
        }
    }

    static void loadDependencyInstance(Object instance, Class<?> clazz, Map<String, Set<DependencyDef>> refMap, Map<String, DynMethodDef> mRefMap, List<DependencyDef> idBoundGenDeps, Set<String> depDirectRefs, String profile, Map<String, String> overriddenAliasMap, Map<String, Set<String>> dynMethodErrors) throws SdfException {
        TypeRef typeRef = TypeRef.fromClass(clazz);
        ConstantInstantiator instantiator = new ConstantInstantiator(instance);
        String fqName = clazz.getName();
        DependencyDef d = DependencyDef.newDependencyInstance(typeRef, instantiator, fqName);
        DependencyUtil.registerDependency(refMap, idBoundGenDeps, typeRef, d, false, false, depDirectRefs);
        DependencyUtil.loadDynamicMethods(profile, mRefMap, clazz, d, refMap, overriddenAliasMap, dynMethodErrors);
    }

    private static void loadDynamicMethods(String profile, Map<String, DynMethodDef> mRefMap, Class<?> c, DependencyDef dep, Map<String, Set<DependencyDef>> refMap, Map<String, String> overriddenAliasMap, Map<String, Set<String>> dynMethodErrors) {
        Method[] ms;
        if (null == mRefMap || c.isInterface() || Modifier.isAbstract(c.getModifiers()) || c.getPackage().getName().startsWith("java.") || c.getCanonicalName() == null) {
            return;
        }
        DependencyUtil.loadDynamicMethods(profile, mRefMap, c.getSuperclass(), dep, refMap, overriddenAliasMap, dynMethodErrors);
        for (Method m : ms = c.getDeclaredMethods()) {
            Optional<DynamicInvocation> optDI = Optional.ofNullable(m.getAnnotation(DynamicInvocation.class));
            if (!Modifier.isPublic(m.getModifiers()) || !optDI.map(d -> !d.disable() && DependencyUtil.matchesProfile(profile, d.profiles(), c.getName()) >= 0).orElse(false).booleanValue()) continue;
            String fqName = c.getName() + '.' + m.getName();
            Parameter[] params = m.getParameters();
            HashMap<Integer, DynMethodArg> argMap = new HashMap<Integer, DynMethodArg>();
            for (int i = 0; i < params.length; ++i) {
                DynMethodArg arg = new DynMethodArg(fqName, params[i], i, (k, f) -> DependencyUtil.excerptVar(k, f, refMap::get));
                argMap.put(i, arg);
            }
            String name = optDI.map(DynamicInvocation::alias).filter(CommonUtil::isNotEmpty).orElse(m.getName());
            name = Optional.of(String.format("sjf.%s.%s.alias", c.getCanonicalName(), name)).map(overriddenAliasMap::get).orElse(name);
            DynMethodDef prev = mRefMap.putIfAbsent(name, new DynMethodDef(c, m, optDI.get().description(), argMap, dep, null));
            if (prev == null) continue;
            if (c.getName().equals(prev.clazz().getName())) {
                throw new SdfException("Dynamic method names must be unique or configured with alias for uniqueness! Method '" + prev.methodName() + "' has multiple occurrences in class " + c.getName());
            }
            Set set = dynMethodErrors.computeIfAbsent(name, x -> new HashSet());
            set.add(c.getCanonicalName());
            set.add(prev.clazz().getCanonicalName());
        }
    }

    private static int matchesProfile(String profile, String[] profiles, String source) {
        int res = 0;
        for (int i = 0; 1 > res && i < profiles.length; ++i) {
            String p = profiles[i];
            if (CommonUtil.isEmpty(p)) {
                throw new SdfException("Profile cannot be empty or null when provided! " + source + " has an empty or null profile.");
            }
            res = p.equals(profile) ? 1 : -1;
        }
        return res;
    }

    static void filterProfileDependencies(String profile, Map.Entry<String, Set<DependencyDef>> entry, Map<String, Set<DependencyDef>> map) {
        if (CommonUtil.isNotEmpty(profile)) {
            for (DependencyDef d : entry.getValue()) {
                if (!profile.equals(d.profile())) continue;
                map.computeIfAbsent(entry.getKey(), x -> new HashSet()).add(d);
            }
        }
    }

    private static void registerDependency(Map<String, Set<DependencyDef>> refMap, List<DependencyDef> idBoundGenDeps, TypeRef typeRef, DependencyDef d, boolean idBoundGeneric, boolean fromEnrich, Set<String> depDirectRefs) {
        if (idBoundGeneric) {
            idBoundGenDeps.add(d);
        } else {
            DependencyUtil.loadParents(typeRef, refMap, d);
            refMap.computeIfAbsent(typeRef.typedName(), k -> new HashSet()).add(d);
            depDirectRefs.add(typeRef.typedName());
            refMap.computeIfAbsent(typeRef.rawName(), k -> new HashSet()).add(d);
        }
        if (!fromEnrich && !CommonUtil.isEmpty(d.getId())) {
            refMap.computeIfAbsent(d.getId(), k -> new HashSet()).add(d);
            depDirectRefs.add(d.getId());
        }
    }

    private static void loadParents(TypeRef typeRef, Map<String, Set<DependencyDef>> refMap, DependencyDef d) {
        Function<TypeRef, String> rawNameF;
        Function<TypeRef, String> typedNameF;
        switch (typeRef.kind()) {
            case Array: {
                AType aType = typeRef.getAsAType();
                typedNameF = aType::formattedTypeName;
                rawNameF = TypeRef::rawName;
                break;
            }
            case GenericArray: {
                GAType gaType = typeRef.getAsGAType();
                typedNameF = gaType::formattedTypeName;
                rawNameF = gaType::formattedRawName;
                break;
            }
            default: {
                typedNameF = TypeRef::typedName;
                rawNameF = TypeRef::rawName;
            }
        }
        for (TypeRef p : typeRef.parents()) {
            switch (p.kind()) {
                case Concrete: {
                    DependencyUtil.parentNotSingletonDependency(typeRef, p.getAsCType().getType());
                    break;
                }
                case Parameterized: {
                    DependencyUtil.parentNotSingletonDependency(typeRef, p.getAsPType().getType());
                }
            }
            refMap.computeIfAbsent(typedNameF.apply(p), k -> new HashSet()).add(d);
            if (p.kind().code() >= 0) continue;
            refMap.computeIfAbsent(rawNameF.apply(p), k -> new HashSet()).add(d);
        }
    }

    private static void parentNotSingletonDependency(TypeRef type, Class<?> parentClass) {
        Dependency annotation;
        if (parentClass != null && parentClass.isAnnotationPresent(Dependency.class) && (annotation = parentClass.getAnnotation(Dependency.class)).singleton()) {
            throw new SdfException("Singleton dependencies cannot be extended. Dependency '" + type.name() + "' extends singleton dependency: " + parentClass.getName() + "\nHint: Make the parent dependency non-singleton.");
        }
    }

    private static Optional<String> excerptVar(String id, boolean isEager, Function<String, Set<DependencyDef>> substitutorF) throws SdfException {
        Optional<String> res = Optional.empty();
        if (DependencyUtil.isVariableKey(id)) {
            String temp = id.substring(2, id.length() - 1);
            if (CommonUtil.isEmpty(temp)) {
                throw new SdfException("Invalid variable key: " + id);
            }
            if (isEager) {
                Set<DependencyDef> deps = substitutorF.apply(temp);
                if (null == deps) {
                    throw new SdfException("Substitution Failed! No value found for variable key: " + id);
                }
                if (deps.size() > 1) {
                    throw new SdfException("Substitution Failed! Multiple value found for variable key: " + id);
                }
                DependencyDef dep = DependencyUtil.firstItem(deps);
                if (!dep.getTypeRef().isStringClass()) {
                    throw new SdfException("Substitution Failed! Value for a variable id must be of type 'java.lang.String'. " + id + " has type " + dep.getTypeRef().name());
                }
                Object obj = dep.getInstantiator().instantiate();
                String string = temp = obj instanceof String ? obj.toString() : null;
                if (null == temp) {
                    throw new SdfException("Variable id '" + id + "' substituted to `null`. a NonNull String value is expected here!");
                }
            }
            res = Optional.of(temp);
        }
        return res;
    }

    static boolean isVariableKey(String id) {
        return id != null && id.length() > 2 && '$' == id.charAt(0) && '{' == id.charAt(1) && '}' == id.charAt(id.length() - 1);
    }

    static <T> T firstItem(Set<T> ts) {
        return ts.iterator().next();
    }

    private static boolean identifyDependencies(DependencyDef d, Parameter[] params, Map<String, Set<DependencyDef>> refMap) throws SdfException {
        HashSet<String> vTypeArgs = new HashSet<String>();
        HashSet<String> rtKeys = new HashSet<String>();
        boolean idBoundGeneric = false;
        for (int i = 0; i < params.length; ++i) {
            DependencyArg arg = new DependencyArg(d.getFullyQualifiedName(), params[i], i, (k, f) -> DependencyUtil.excerptVar(k, f, refMap::get));
            idBoundGeneric = idBoundGeneric || arg.isIdBound() && !arg.getTypeRef().vTypes().isEmpty();
            d.addArgument(i, arg);
            vTypeArgs.addAll(arg.getTypeRef().vTypes());
            if (!arg.isRealtime() || rtKeys.add(arg.getRealtimeMeta().key())) continue;
            throw new SdfException("@Realtime key must be unique in constructor/method! Key '" + arg.getRealtimeMeta().key() + "' is not unique in " + d.getFullyQualifiedName());
        }
        Set notMappedVTypes = d.getTypeRef().vTypes().stream().filter(v -> !vTypeArgs.contains(v)).collect(Collectors.toSet());
        if (!notMappedVTypes.isEmpty()) {
            throw new SdfException("TypeVariable(s) in a @Dependency/@DependencyProvider must either be bound using @Bind or marked as @Realtime for realtime values! '" + d.getFullyQualifiedName() + "' has un-resolved TypeVariable(s): " + notMappedVTypes);
        }
        return idBoundGeneric;
    }

    private static Method findMethod(Class<?> clazz, String methodName) throws SdfException {
        Method method = null;
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methodName.equals(methods[i].getName())) continue;
            method = methods[i];
            i = methods.length;
        }
        if (method == null) {
            throw new SdfException("Method " + methodName + " not found in class " + clazz.getName());
        }
        return method;
    }

    private static String constructorName(Constructor<?> constructor) {
        return String.format("%s(%s)", constructor.getName(), Arrays.stream(constructor.getParameterTypes()).map(Class::getName).collect(Collectors.joining(",")));
    }
}

