/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.di.internal;

import com.simplj.di.annotations.Implicit;
import com.simplj.di.annotations.Label;
import com.simplj.di.annotations.Realtime;
import com.simplj.di.annotations.SubTypes;
import com.simplj.di.annotations.Tag;
import com.simplj.di.exceptions.SdfException;
import com.simplj.di.internal.CommonUtil;
import com.simplj.di.internal.DependencyDef;
import com.simplj.di.internal.DependencyInstantiator;
import com.simplj.di.internal.ParameterMeta;
import com.simplj.di.internal.TypeRef;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;

final class DynMethodArg {
    private final Parameter parameter;
    private final TypeRef typeRef;
    private final int index;
    private final String label;
    private final ParameterMeta rtMeta;
    private final ParameterMeta subTypes;
    private final boolean isRealtimeArg;
    private final boolean isRealtimeParam;
    private final boolean isImplicit;
    private final boolean isIdBound;
    private final boolean isSubTypes;
    private final boolean isNullable;
    private final String typeNameOrId;
    private final boolean isSubstituted;
    private final String substitutedFrom;
    private final String tag;
    private DependencyInstantiator implicitInstantiator;
    private Object subTypeVal;

    DynMethodArg(String srcClass, Parameter parameter, int index, BiFunction<String, Boolean, Optional<String>> varExcerptF) throws SdfException {
        this.parameter = parameter;
        this.index = index;
        this.label = Optional.ofNullable(parameter.getAnnotation(Label.class)).map(Label::value).orElse(null);
        Implicit im = parameter.getAnnotation(Implicit.class);
        Realtime rtp = parameter.getAnnotation(Realtime.class);
        SubTypes st = parameter.getAnnotation(SubTypes.class);
        this.isImplicit = im != null;
        this.isIdBound = this.isImplicit && CommonUtil.isNotEmpty(im.id());
        this.isRealtimeParam = rtp != null;
        this.isSubTypes = st != null;
        int sum = (this.isImplicit ? 1 : 0) + (this.isRealtimeParam ? 1 : 0) + (this.isSubTypes ? 1 : 0);
        if (sum > 1) {
            throw new SdfException("Either of @Implicit/@Realtime/@SubTypes can be used on a parameter. Multiple annotations are used on parameter at index " + index + " in '" + srcClass + '\'');
        }
        boolean bl = this.isRealtimeArg = 0 == sum;
        if (this.isRealtimeParam) {
            this.isNullable = rtp.nullable();
            CommonUtil.validateNullable(srcClass, this.isNullable, parameter);
            this.typeRef = TypeRef.fromParameter(parameter);
            this.isSubstituted = false;
            this.substitutedFrom = null;
            this.subTypes = null;
            this.typeNameOrId = null;
            Optional<String> optSubsId = varExcerptF.apply(rtp.key(), false);
            this.rtMeta = new ParameterMeta(optSubsId.orElse(rtp.key()), optSubsId.isPresent(), rtp.key(), rtp.nullable(), parameter.getType());
        } else if (this.isImplicit) {
            this.isNullable = im.nullable();
            CommonUtil.validateNullable(srcClass, this.isNullable, parameter);
            this.typeRef = TypeRef.fromParameter(parameter);
            this.rtMeta = null;
            this.subTypes = null;
            if (this.isIdBound) {
                String id = im.id();
                Optional<String> optSubsId = varExcerptF.apply(id, true);
                this.isSubstituted = optSubsId.isPresent();
                this.substitutedFrom = id;
                this.typeNameOrId = optSubsId.orElse(id);
            } else {
                if (!this.typeRef.vTypes().isEmpty()) {
                    throw new SdfException("Type Variable in Parameter is not allowed! Parameter at index " + index + " in '" + srcClass + "' has type: " + this.typeRef.name());
                }
                this.isSubstituted = false;
                this.substitutedFrom = null;
                this.typeNameOrId = this.typeRef.name();
            }
        } else if (this.isSubTypes) {
            this.isNullable = st.emptyIfNotFound();
            boolean isMap = parameter.getType().equals(Map.class);
            boolean isList = parameter.getType().equals(List.class);
            if (!isMap && !isList) {
                throw new SdfException("Only `Map` or `List` type is supported to have @SubTypes annotation! @SubTypes parameter at index " + index + " in '" + srcClass + "' has type: " + parameter.getType());
            }
            ParameterizedType pt = (ParameterizedType)parameter.getParameterizedType();
            int idx = 0;
            if (isMap) {
                String keyType = pt.getActualTypeArguments()[idx].getTypeName();
                if (!String.class.getName().equals(keyType)) {
                    throw new SdfException("@SubTypes Map must contain String as key! Parameter at index " + index + " in '" + srcClass + "' has '" + keyType + "' as key.");
                }
                idx = 1;
            }
            this.typeRef = TypeRef.fromType(pt.getActualTypeArguments()[idx]);
            if (!this.typeRef.vTypes().isEmpty()) {
                throw new SdfException("Type Variable in @SubTypes is not allowed! @SubTypes parameter at index " + index + " in '" + srcClass + "' has type: " + this.typeRef.name());
            }
            this.subTypes = new ParameterMeta(this.typeRef.rawName(), false, null, st.emptyIfNotFound(), parameter.getType());
            this.rtMeta = null;
            this.isSubstituted = false;
            this.substitutedFrom = null;
            this.typeNameOrId = null;
        } else {
            this.isNullable = false;
            this.typeRef = TypeRef.fromParameter(parameter);
            this.rtMeta = null;
            this.subTypes = null;
            this.isSubstituted = false;
            this.substitutedFrom = null;
            this.typeNameOrId = null;
        }
        Tag tag = parameter.getAnnotation(Tag.class);
        this.tag = tag == null ? null : tag.value();
    }

    TypeRef getTypeRef() {
        return this.typeRef;
    }

    Class<?> getType() {
        return this.parameter.getType();
    }

    String getTypeNameOrId() {
        return this.typeNameOrId;
    }

    int getIndex() {
        return this.index;
    }

    String label() {
        return this.label;
    }

    boolean isSubstituted() {
        return this.isSubstituted;
    }

    boolean isImplicit() {
        return this.isImplicit;
    }

    boolean isIdBound() {
        return this.isIdBound;
    }

    boolean isRealtimeArg() {
        return this.isRealtimeArg;
    }

    boolean isRealtimeParam() {
        return this.isRealtimeParam;
    }

    boolean isSubTypes() {
        return this.isSubTypes;
    }

    boolean isNullable() {
        return this.isNullable;
    }

    String getSubstitutedFrom() {
        return this.substitutedFrom;
    }

    ParameterMeta getRealtimeParamMeta() {
        return this.rtMeta;
    }

    ParameterMeta getSubTypesMeta() {
        return this.subTypes;
    }

    String getTag() {
        return this.tag;
    }

    Object getImplicitInstance(Map<String, Object> rtParams, Function<String, DependencyDef> depF) {
        return this.implicitInstantiator.instantiate(rtParams, depF);
    }

    void setImplicitInstantiator(DependencyInstantiator implicitInstantiator) {
        this.implicitInstantiator = implicitInstantiator;
    }

    Object subTypeVal() {
        return this.subTypeVal;
    }

    void setSubTypeVal(Object subTypeVal) {
        this.subTypeVal = subTypeVal;
    }

    public String toString() {
        return String.format("{arg: idx=%s, typeNameOrId=%s}", this.index, this.typeNameOrId);
    }
}

