/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.di.internal;

import com.simplj.di.exceptions.SdfException;
import com.simplj.di.internal.CommonUtil;
import com.simplj.di.internal.DependencyDef;
import com.simplj.di.internal.DependencyInstantiator;
import com.simplj.di.internal.DynMethodArg;
import com.simplj.di.internal.TypeRef;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

class DynMethodDef {
    private final Class<?> clazz;
    private final Method method;
    private final TypeRef returnType;
    private final String description;
    private final String signature;
    private final Map<Integer, DynMethodArg> idxArgMap;
    private final DependencyInstantiator instantiator;
    private Object instance;

    DynMethodDef(Class<?> clazz, Method method, String desc, Map<Integer, DynMethodArg> idxArgMap, DependencyDef dep, Object instance) {
        this.clazz = clazz;
        this.method = method;
        this.returnType = TypeRef.fromMethod(method);
        this.description = desc;
        this.signature = clazz.getName() + '#' + method.getName() + '(' + idxArgMap.values().stream().map(a -> a.getType().getSimpleName()).collect(Collectors.joining(", ")) + ')';
        this.idxArgMap = idxArgMap;
        this.instantiator = dep.getInstantiator();
        this.instance = instance;
    }

    Class<?> clazz() {
        return this.clazz;
    }

    String methodName() {
        return this.method.getName();
    }

    TypeRef returnType() {
        return this.returnType;
    }

    public String description() {
        return this.description;
    }

    Map<Integer, DynMethodArg> getIdxArgMap() {
        return this.idxArgMap;
    }

    Object invoke(Map<String, Object> rtParams, Object[] rtArgs, Function<String, DependencyDef> depF) {
        Object res;
        long rtArgsCount = this.idxArgMap.values().stream().filter(DynMethodArg::isRealtimeArg).count();
        if (rtArgsCount != (long)rtArgs.length) {
            throw new SdfException("Method '" + this.method.getName() + "' of class " + this.clazz.getName() + " expects " + rtArgsCount + " realtime arguments but provided " + rtArgs.length);
        }
        Object[] args = new Object[this.idxArgMap.size()];
        int rtIdx = 0;
        for (int i = 0; i < args.length; ++i) {
            DynMethodArg arg = this.idxArgMap.get(i);
            if (arg.isRealtimeArg()) {
                args[i] = rtArgs[rtIdx++];
                continue;
            }
            if (arg.isRealtimeParam()) {
                args[arg.getIndex()] = CommonUtil.getRealtimeParam(rtParams, depF, arg.getRealtimeParamMeta(), "Failed to invoke dynamic method '" + this.method.getName());
                continue;
            }
            if (arg.isSubTypes()) {
                args[arg.getIndex()] = arg.subTypeVal();
                continue;
            }
            if (arg.isImplicit()) {
                Object obj = arg.getImplicitInstance(rtParams, depF);
                if (obj == null && !arg.isNullable()) {
                    throw new SdfException("Failed to invoke dynamic method '" + this.method.getName() + "'! Reason: Could not find not-nullable dependency [" + arg.getTypeNameOrId() + "]. Hint: Mark the parameter as `nullable=true` if optional.");
                }
                args[arg.getIndex()] = obj;
                continue;
            }
            throw new SdfException("Internal: Argument at " + i + " is neither realtime nor subTypes nor implicit! This should not have happened, please contact @SDF Support team with this error.");
        }
        if (this.instance == null) {
            this.instance = this.instantiator.instantiate();
        }
        try {
            res = this.method.invoke(this.instance, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new SdfException("Failed to invoke dynamic method '" + this.method.getName() + "'! Error: " + e.getMessage());
        }
        return res;
    }

    public String toString() {
        return "DMD{" + this.signature + '}';
    }
}

