/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.di.internal;

import com.simplj.di.internal.CType;
import com.simplj.di.internal.Kind;
import com.simplj.di.internal.PType;
import com.simplj.di.internal.TypeRef;
import com.simplj.di.internal.VType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

final class LBType
extends TypeRef {
    private final List<TypeRef> types;
    private final Set<String> vTypes;
    private final String typedName;
    private final String rawName;

    LBType(Type rawType, List<TypeRef> types) {
        super(rawType);
        this.types = types;
        this.vTypes = types.isEmpty() ? Collections.emptySet() : types.stream().flatMap(t -> t.vTypes().stream()).collect(Collectors.toSet());
        this.typedName = types.stream().map(TypeRef::typedName).collect(Collectors.joining(" & "));
        this.rawName = types.stream().map(TypeRef::rawName).collect(Collectors.joining(" & "));
    }

    List<TypeRef> getTypes() {
        return this.types;
    }

    @Override
    public boolean isAssignableFrom(TypeRef ref) {
        boolean res = false;
        if (ref != null) {
            switch (ref.kind()) {
                case Concrete: {
                    CType cType = (CType)ref;
                    res = this.types.stream().allMatch(cType::isAssignableFrom);
                    break;
                }
                case Parameterized: {
                    PType pType = (PType)ref;
                    res = this.types.stream().allMatch(pType::isAssignableFrom);
                    break;
                }
                case LowerBounded: {
                    LBType lbType = (LBType)ref;
                    res = this.types.size() == lbType.getTypes().size();
                    for (int i = 0; res && i < this.types.size(); ++i) {
                        res = lbType.getTypes().get(i).isAssignableFrom(this.types.get(i));
                    }
                    break;
                }
                case Variable: {
                    VType vType = (VType)ref;
                    res = vType.isTyped() && this.isAssignableFrom(vType.getType());
                }
            }
        }
        return res;
    }

    @Override
    List<TypeRef> parents() {
        return Collections.emptyList();
    }

    @Override
    Set<String> vTypes() {
        return this.vTypes;
    }

    @Override
    void updateVTypesFrom(TypeRef ref, Map<String, TypeRef> accumulator) {
        LBType lbType = ref.getAsLBType();
        if (lbType != null && this.types.size() == lbType.types.size()) {
            for (int i = 0; i < this.types.size(); ++i) {
                this.types.get(i).updateVTypesFrom(lbType.types.get(i), accumulator);
            }
        }
    }

    @Override
    void updateVTypes(Map<String, TypeRef> varTypeMap) {
        for (TypeRef type : this.types) {
            type.updateVTypes(varTypeMap);
        }
    }

    @Override
    boolean isTyped() {
        return this.types.stream().allMatch(TypeRef::isTyped);
    }

    @Override
    Kind kind() {
        return Kind.LowerBounded;
    }

    @Override
    public String name() {
        return String.format("? super %s", this.typedName);
    }

    @Override
    public String rawName() {
        return this.rawName;
    }

    @Override
    public String typedName() {
        return this.typedName;
    }
}

