/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.di.internal;

import com.simplj.di.internal.BType;
import com.simplj.di.internal.CType;
import com.simplj.di.internal.Kind;
import com.simplj.di.internal.LBType;
import com.simplj.di.internal.TypeRef;
import com.simplj.di.internal.UBType;
import com.simplj.di.internal.VType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

final class PType
extends TypeRef {
    private final Class<?> type;
    private final List<TypeRef> pTypes;
    private final Set<String> vTypes;
    private final List<TypeRef> parentTypes;

    PType(Class<?> clazz, Type rawType, List<TypeRef> pTypes, List<TypeRef> parents) {
        super(rawType);
        this.type = clazz;
        this.pTypes = pTypes;
        this.vTypes = pTypes.stream().flatMap(t -> t.vTypes().stream()).collect(Collectors.toSet());
        this.parentTypes = parents;
    }

    Class<?> getType() {
        return this.type;
    }

    List<TypeRef> getPTypes() {
        return this.pTypes;
    }

    @Override
    public boolean isAssignableFrom(TypeRef ref) {
        boolean res = false;
        if (ref != null) {
            switch (ref.kind()) {
                case Concrete: {
                    CType cType = (CType)ref;
                    List<TypeRef> cParents = cType.parents();
                    for (int i = 0; !res && i < cParents.size(); ++i) {
                        res = this.isAssignableFrom(cParents.get(i));
                    }
                    break;
                }
                case Parameterized: {
                    PType pType = (PType)ref;
                    if (!this.type.isAssignableFrom(pType.getType())) break;
                    res = this.pTypes.size() == pType.pTypes.size();
                    for (int i = 0; res && i < this.pTypes.size(); ++i) {
                        res = this.pTypes.get(i).isAssignableFrom(pType.pTypes.get(i));
                    }
                    if (res) break;
                    List<TypeRef> pParents = pType.parentTypes;
                    for (int i = 0; !res && i < pParents.size(); ++i) {
                        res = this.isAssignableFrom(pParents.get(i));
                    }
                    break;
                }
                case Bounded: {
                    BType bType = (BType)ref;
                    res = bType.getTypes().stream().allMatch(this::isAssignableFrom);
                    break;
                }
                case UpperBounded: {
                    UBType ubType = (UBType)ref;
                    res = ubType.getTypes().stream().allMatch(this::isAssignableFrom);
                    break;
                }
                case LowerBounded: {
                    LBType lbType = (LBType)ref;
                    res = lbType.getTypes().stream().allMatch(t -> t.isAssignableFrom(this));
                    break;
                }
                case Variable: {
                    VType vType = (VType)ref;
                    res = vType.isTyped() && this.isAssignableFrom(vType.getType());
                }
            }
        }
        return res;
    }

    @Override
    List<TypeRef> parents() {
        return this.parentTypes;
    }

    @Override
    Set<String> vTypes() {
        return this.vTypes;
    }

    @Override
    void updateVTypesFrom(TypeRef ref, Map<String, TypeRef> accumulator) {
        PType pType = ref.getAsPType();
        if (pType != null && this.pTypes.size() == pType.pTypes.size()) {
            for (int i = 0; i < this.pTypes.size(); ++i) {
                this.pTypes.get(i).updateVTypesFrom(pType.pTypes.get(i), accumulator);
            }
            HashMap<String, TypeRef> parentMap = new HashMap<String, TypeRef>();
            for (TypeRef p : pType.parentTypes) {
                parentMap.put(p.rawName(), p);
            }
            for (TypeRef p : this.parentTypes) {
                TypeRef temp = (TypeRef)parentMap.get(p.rawName());
                if (temp == null) continue;
                p.updateVTypesFrom(temp, accumulator);
            }
        }
    }

    @Override
    void updateVTypes(Map<String, TypeRef> varTypeMap) {
        for (TypeRef pType : this.pTypes) {
            pType.updateVTypes(varTypeMap);
        }
        for (TypeRef pt : this.parentTypes) {
            pt.updateVTypes(varTypeMap);
        }
    }

    @Override
    boolean isTyped() {
        return this.pTypes.stream().allMatch(TypeRef::isTyped);
    }

    @Override
    Kind kind() {
        return Kind.Parameterized;
    }

    @Override
    public String name() {
        return String.format("%s<%s>", this.sn ? this.type.getSimpleName() : this.type.getTypeName(), this.pTypes.stream().map(TypeRef::name).collect(Collectors.joining(",")));
    }

    @Override
    public String rawName() {
        return this.sn ? this.type.getSimpleName() : this.type.getTypeName();
    }

    @Override
    public String typedName() {
        return String.format("%s<%s>", this.sn ? this.type.getSimpleName() : this.type.getTypeName(), this.pTypes.stream().map(TypeRef::typedName).collect(Collectors.joining(",")));
    }
}

