/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.di.internal;

import com.simplj.di.exceptions.SdfException;
import com.simplj.di.internal.ConstructorInstantiator;
import com.simplj.di.internal.DependencyInstantiator;
import com.simplj.di.internal.MethodInstantiator;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class SingletonInstantiator
extends DependencyInstantiator {
    private final ConstructorInstantiator cInit;
    private final MethodInstantiator mInit;
    private final boolean isConsInit;
    private final Map<String, Object> instanceMap;

    SingletonInstantiator(Constructor<?> constructor) {
        this(new ConstructorInstantiator(constructor), null, true);
    }

    SingletonInstantiator(Method method, Object instance) {
        this(null, new MethodInstantiator(method, instance), false);
    }

    private SingletonInstantiator(ConstructorInstantiator c, MethodInstantiator m, boolean isConstructor) {
        this.cInit = c;
        this.mInit = m;
        this.isConsInit = isConstructor;
        this.instanceMap = new ConcurrentHashMap<String, Object>();
    }

    @Override
    Class<?> type() {
        return this.isConsInit ? this.cInit.type() : this.mInit.type();
    }

    @Override
    Object instantiate(String key, Object[] args) throws SdfException {
        return this.instanceMap.computeIfAbsent(key, k -> this.getInstance((String)k, args));
    }

    private Object getInstance(String key, Object[] args) {
        Object res = null;
        if (this.cInit != null) {
            res = this.cInit.instantiate(key, args);
        } else if (this.mInit != null) {
            res = this.mInit.instantiate(key, args);
        }
        return res;
    }
}

