/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.di.internal;

import com.simplj.di.internal.AType;
import com.simplj.di.internal.BType;
import com.simplj.di.internal.CType;
import com.simplj.di.internal.CommonUtil;
import com.simplj.di.internal.GAType;
import com.simplj.di.internal.Kind;
import com.simplj.di.internal.LBType;
import com.simplj.di.internal.PType;
import com.simplj.di.internal.PTypeRef;
import com.simplj.di.internal.TypeUtil;
import com.simplj.di.internal.UBType;
import com.simplj.di.internal.VType;
import com.simplj.di.internal.WType;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public abstract class TypeRef {
    boolean sn = false;
    private final Type rawType;

    protected TypeRef(Type rawType) {
        this.rawType = rawType;
    }

    public boolean isAssignableTo(TypeRef ref) {
        return ref != null && ref.isAssignableFrom(this);
    }

    public abstract boolean isAssignableFrom(TypeRef var1);

    abstract List<TypeRef> parents();

    abstract Set<String> vTypes();

    abstract void updateVTypesFrom(TypeRef var1, Map<String, TypeRef> var2);

    abstract void updateVTypes(Map<String, TypeRef> var1);

    abstract boolean isTyped();

    abstract Kind kind();

    public abstract String name();

    public abstract String rawName();

    public abstract String typedName();

    Type rawType() {
        return this.rawType;
    }

    CType getAsCType() {
        return this instanceof CType ? (CType)this : null;
    }

    AType getAsAType() {
        return this instanceof AType ? (AType)this : null;
    }

    PType getAsPType() {
        return this instanceof PType ? (PType)this : null;
    }

    GAType getAsGAType() {
        return this instanceof GAType ? (GAType)this : null;
    }

    BType getAsBType() {
        return this instanceof BType ? (BType)this : null;
    }

    UBType getAsUBType() {
        return this instanceof UBType ? (UBType)this : null;
    }

    LBType getAsLBType() {
        return this instanceof LBType ? (LBType)this : null;
    }

    WType getAsWType() {
        return this instanceof WType ? (WType)this : null;
    }

    VType getAsVType() {
        return this instanceof VType ? (VType)this : null;
    }

    boolean isStringClass() {
        return Optional.ofNullable(this.getAsCType()).map(c -> String.class.equals(c.getType())).orElse(false);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.name();
    }

    static TypeRef fromClass(Class<?> clazz) {
        TypeRef res;
        HashSet<String> visitedTypes = new HashSet<String>();
        LinkedList<TypeRef> parents = new LinkedList<TypeRef>();
        if (CommonUtil.isEmpty(clazz.getTypeParameters())) {
            res = TypeRef.fromType(clazz, clazz, visitedTypes, true);
        } else {
            TypeRef.crawlParents(parents, clazz, clazz, visitedTypes);
            res = TypeRef.pType(clazz, clazz.getTypeParameters(), parents, visitedTypes);
        }
        return res;
    }

    static TypeRef fromMethod(Method method) {
        return TypeRef.fromType(method.getGenericReturnType(), method.getReturnType(), new HashSet<String>(), true);
    }

    static TypeRef fromParameter(Parameter parameter) {
        return TypeRef.fromType(parameter.getParameterizedType(), parameter.getType(), new HashSet<String>(), false);
    }

    static TypeRef fromType(Type type) {
        return TypeRef.fromType(type, null, new HashSet<String>(), false);
    }

    static TypeRef fromType(Type type, Class<?> clazz, Set<String> visitedTypes, boolean crawlParents) {
        TypeRef res = null;
        if (type == null) {
            return res;
        }
        if (type instanceof Class) {
            Class c = (Class)type;
            if (c.isArray()) {
                res = new AType(c, crawlParents);
            } else {
                List<TypeRef> parents;
                if (crawlParents) {
                    parents = new LinkedList();
                    TypeRef.crawlParents(parents, clazz == null ? TypeUtil.toClass(type) : clazz, type, visitedTypes);
                } else {
                    parents = Collections.emptyList();
                }
                res = new CType(c, parents);
            }
        } else if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Class<?> pClass = clazz == null ? TypeUtil.toClass(pt.getRawType()) : clazz;
            if (!visitedTypes.contains(pClass.getTypeName())) {
                List<TypeRef> parents;
                if (crawlParents) {
                    parents = new LinkedList();
                    TypeRef.crawlParents(parents, pClass, type, visitedTypes);
                } else {
                    parents = Collections.emptyList();
                }
                res = TypeRef.pType(pClass, pt.getActualTypeArguments(), parents, visitedTypes);
            }
        } else if (type instanceof TypeVariable) {
            List<TypeRef> typeBounds;
            TypeVariable tv = (TypeVariable)type;
            Type[] bounds = tv.getBounds();
            res = TypeRef.isEmpty(bounds) ? new VType(type, tv.getName()) : (CommonUtil.isEmpty(typeBounds = TypeRef.getTypeRefs(clazz, bounds, visitedTypes)) ? new VType(type, tv.getName()) : new BType(type, tv.getName(), typeBounds));
        } else if (type instanceof WildcardType) {
            WildcardType wt = (WildcardType)type;
            boolean noUpperBound = TypeRef.isEmpty(wt.getUpperBounds());
            boolean noLowerBound = TypeRef.isEmpty(wt.getLowerBounds());
            res = noUpperBound && noLowerBound ? new WType(type) : (noLowerBound ? new UBType(type, TypeRef.getTypeRefs(clazz, wt.getUpperBounds(), visitedTypes)) : new LBType(type, TypeRef.getTypeRefs(clazz, wt.getLowerBounds(), visitedTypes)));
        } else if (type instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)type;
            res = new GAType(gat);
        } else {
            System.out.println("Unhandled Type: " + type.getClass());
        }
        return res;
    }

    static void crawlParents(List<TypeRef> parents, Class<?> clazz, Type type, Set<String> visitedTypes) {
        Class<?> curr;
        Class<?> pClass;
        boolean reachedTop;
        if (clazz == null || clazz.equals(Object.class) || visitedTypes.contains(clazz.getTypeName())) {
            return;
        }
        visitedTypes.add(clazz.getTypeName());
        HashMap<String, TypeRef> varTypeMap = new HashMap<String, TypeRef>();
        List<TypeRef> gTypes = null;
        if (type instanceof ParameterizedType) {
            gTypes = TypeRef.getTypeRefs(clazz, ((ParameterizedType)type).getActualTypeArguments(), visitedTypes);
            TypeRef.mapActualTypes(clazz, gTypes, varTypeMap);
        }
        boolean bl = reachedTop = (pClass = (curr = clazz).getSuperclass()) == null || pClass.getName().equals("java.lang.Object");
        if (reachedTop) {
            TypeRef.crawlInterfaces(clazz, parents, curr, varTypeMap, visitedTypes);
        }
        while (!reachedTop) {
            Type gType = curr.getGenericSuperclass();
            if (gType instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)gType;
                gTypes = TypeRef.reMapTypes(clazz, curr.getSuperclass(), pType, varTypeMap, visitedTypes);
                parents.add(new PType(pClass, pType, gTypes, Collections.emptyList()));
            } else {
                if (!(gType instanceof Class)) {
                    System.out.println("Not handled type: " + gType.getTypeName());
                }
                parents.add(new CType(pClass, Collections.emptyList()));
            }
            TypeRef.crawlInterfaces(clazz, parents, curr, varTypeMap, visitedTypes);
            varTypeMap.clear();
            TypeRef.mapActualTypes(pClass, gTypes, varTypeMap);
            curr = pClass;
            pClass = curr.getSuperclass();
            visitedTypes.clear();
            reachedTop = pClass == null || pClass.getName().equals("java.lang.Object");
        }
    }

    private static PType pType(Class<?> clazz, Type[] types, List<TypeRef> parents, Set<String> visitedTypes) {
        List<TypeRef> pRefs = TypeRef.getTypeRefs(clazz, types, visitedTypes);
        return new PType(clazz, new PTypeRef(clazz, types, null), pRefs, parents);
    }

    private static boolean isEmpty(Type[] types) {
        return CommonUtil.isEmpty(types) || types[0].equals(Object.class);
    }

    private static List<Class<?>> loadClasses(Type[] types) {
        ArrayList classes = new ArrayList(types.length);
        for (Type t : types) {
            classes.add(TypeUtil.toClass(t));
        }
        return classes;
    }

    private static List<TypeRef> getTypeRefs(Class<?> pClass, Type[] types, Set<String> visitedTypes) {
        ArrayList<TypeRef> pRefs = new ArrayList<TypeRef>(types.length);
        int i = 0;
        for (Type t : types) {
            TypeRef typeRef = TypeRef.fromType(t, null, visitedTypes, true);
            if (typeRef == null && pClass != null && Arrays.stream(pClass.getTypeParameters()[i].getBounds()).anyMatch(b -> TypeRef.isSame(pClass, b))) {
                typeRef = TypeRef.fromType(t, null, Collections.emptySet(), false);
            }
            if (typeRef != null) {
                pRefs.add(typeRef);
            }
            ++i;
        }
        return pRefs;
    }

    private static boolean isSame(Class<?> c, Type t) {
        boolean res = false;
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            res = pt.getRawType().equals(c);
        }
        return res;
    }

    private static void crawlInterfaces(Class<?> source, List<TypeRef> parents, Class<?> clazz, Map<String, TypeRef> varTypeMap, Set<String> visitedTypes) {
        Type[] igTypes;
        Class<?>[] iClasses = clazz.getInterfaces();
        if (iClasses.length != (igTypes = clazz.getGenericInterfaces()).length) {
            System.out.println("Weird Case: interfaces.length and genericInterfaces.length does not match for class: " + clazz.getName());
        }
        for (int i = 0; i < iClasses.length; ++i) {
            Class<?> iClass = iClasses[i];
            Type iType = igTypes[i];
            if (iType instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)iType;
                List<TypeRef> gTypes = TypeRef.reMapTypes(source, iClass, pType, varTypeMap, visitedTypes);
                TypeRef.mapActualTypes(iClass, gTypes, varTypeMap);
                parents.add(new PType(iClass, pType, gTypes, Collections.emptyList()));
            } else {
                if (!(iType instanceof Class)) {
                    System.out.println("Not handled type: " + iType.getTypeName());
                }
                parents.add(new CType(iClass, Collections.emptyList()));
            }
            TypeRef.crawlInterfaces(source, parents, iClass, varTypeMap, visitedTypes);
        }
    }

    private static void mapActualTypes(Class<?> clazz, List<TypeRef> gTypes, Map<String, TypeRef> varTypeMap) {
        if (clazz.getTypeParameters().length == 0) {
            return;
        }
        if (gTypes == null) {
            System.out.println("Weird Case: Super class has type variable but child class does not have. Should not have come here, instead have caught by compiler itself! Erroneous Class: " + clazz.getName());
            return;
        }
        if (clazz.getTypeParameters().length != gTypes.size()) {
            System.out.println("Weird Case: Type Parameters size does not match with Generic Type Parameters for class: " + clazz.getName());
            System.out.println(clazz.getTypeParameters().length + " vs " + gTypes);
            return;
        }
        for (int i = 0; i < clazz.getTypeParameters().length; ++i) {
            TypeVariable<Class<?>> tv = clazz.getTypeParameters()[i];
            varTypeMap.put(tv.getName(), gTypes.get(i));
        }
    }

    private static List<TypeRef> reMapTypes(Class<?> source, Class<?> pClass, ParameterizedType pType, Map<String, TypeRef> varTypeMap, Set<String> visitedTypes) {
        List<TypeRef> currTypes = TypeRef.getTypeRefs(pClass, pType.getActualTypeArguments(), visitedTypes);
        for (int i = 0; i < currTypes.size(); ++i) {
            TypeRef tr = currTypes.get(i);
            String var = TypeRef.getTypeVarName(tr);
            if (var == null) continue;
            tr = varTypeMap.get(var);
            if (tr == null) {
                System.out.println("WARNING: Could not substitute Type Variable " + currTypes.get(i).rawName() + " in class: " + pType.getTypeName() + "! Source Class: " + source.getTypeName());
                continue;
            }
            currTypes.set(i, tr);
        }
        return currTypes;
    }

    private static String getTypeVarName(TypeRef typeRef) {
        String res;
        switch (typeRef.kind()) {
            case Bounded: {
                res = typeRef.getAsBType().varName();
                break;
            }
            case Variable: {
                res = typeRef.name();
                break;
            }
            default: {
                res = null;
            }
        }
        return res;
    }
}

