/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.di.internal;

import com.simplj.di.exceptions.SdfException;
import com.simplj.di.internal.PrimitiveType;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class TypeUtil {
    static final Map<String, PrimitiveType> primitiveTypeMap;
    static final Map<Class<?>, Function<String, Object>> wrapperFromStringMap;
    static final Set<String> primitiveTypes;
    static final Set<String> wrapperTypes;

    public static Class<?> toClass(Type type) {
        try {
            return Class.forName(type.getTypeName());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not resolve class: " + type.getTypeName() + "! Error: " + e.getMessage());
        }
    }

    public static <T> T typeCast(Class<T> type, Object o) throws SdfException {
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null!");
        }
        if (o == null) {
            if (type.isPrimitive()) {
                throw new IllegalArgumentException("`null` cannot be set to primitive!");
            }
            return null;
        }
        if (!type.isAssignableFrom(o.getClass())) {
            if (o.getClass().equals(String.class) || wrapperTypes.contains(o.getClass().getTypeName())) {
                type = TypeUtil.getWrapperIfPrimitives(type);
                o = TypeUtil.convertFromString(o.toString(), type);
            } else if (type.isArray() && o.getClass().isArray()) {
                o = TypeUtil.tryConvertingArrayTypes(type, o);
            } else {
                throw new IllegalArgumentException("Unable get instance of type '" + type.getTypeName() + "' from type '" + o.getClass().getTypeName() + "'!");
            }
        }
        return type.cast(o);
    }

    static boolean isSupportedPrimitive(String name) {
        return primitiveTypes.contains(name);
    }

    static boolean isPrimitiveOrWrapper(String name) {
        return wrapperTypes.contains(name) || TypeUtil.isSupportedPrimitive(name);
    }

    private static Object tryConvertingArrayTypes(Class<?> target, Object source) {
        Object res = null;
        if (source != null) {
            int sum = (target.isArray() ? 1 : 0) + (source.getClass().isArray() ? 1 : 0);
            switch (sum) {
                case 2: {
                    Object[] arr = TypeUtil.toArray(source);
                    res = TypeUtil.tryConvertingArrays(target.getComponentType(), arr);
                    break;
                }
                case 0: {
                    if (target.isAssignableFrom(source.getClass())) {
                        res = target.cast(source);
                        break;
                    }
                    throw new IllegalArgumentException("Could not convert arrays of type '" + source.getClass().getTypeName() + "' to type '" + target.getTypeName() + "'!");
                }
                default: {
                    throw new IllegalArgumentException("Could not convert arrays of type '" + source.getClass().getTypeName() + "' to type '" + target.getTypeName() + "'!");
                }
            }
        }
        return res;
    }

    private static Object[] toArray(Object source) {
        PrimitiveType pt = primitiveTypeMap.get(source.getClass().getComponentType().getTypeName());
        Object[] res = pt == null ? (Object[])source : pt.toWrapperArray(source);
        return res;
    }

    private static <T> Object tryConvertingArrays(Class<T> type, Object[] src) {
        Object[] res;
        PrimitiveType pt = primitiveTypeMap.get(type.getTypeName());
        if (pt == null) {
            Object[] arr = (Object[])Array.newInstance(type, src.length);
            for (int i = 0; i < src.length; ++i) {
                arr[i] = TypeUtil.typeCast(type, src[i]);
            }
            res = arr;
        } else {
            res = pt.fromWrapperArray(src);
        }
        return res;
    }

    private static <T> Class<T> getWrapperIfPrimitives(Class<T> type) {
        PrimitiveType pt = primitiveTypeMap.get(type.getTypeName());
        if (pt != null) {
            type = pt.wrapperType();
        }
        return type;
    }

    private static Object convertFromString(String value, Class<?> to) {
        Object res;
        try {
            Function<String, Object> fromStringF = wrapperFromStringMap.get(to);
            if (fromStringF == null) {
                throw new SdfException("Cannot implicitly convert value '" + value + "' of type " + value.getClass().getTypeName() + " to type " + to.getTypeName() + '!');
            }
            res = fromStringF.apply(value);
        }
        catch (Exception ex) {
            if (ex instanceof SdfException) {
                throw ex;
            }
            throw new SdfException("Could not convert value '" + value + "' to type " + to.getTypeName());
        }
        return res;
    }

    static {
        PrimitiveType[] supportedPrimTypes;
        primitiveTypeMap = new HashMap<String, PrimitiveType>();
        wrapperFromStringMap = new HashMap();
        for (PrimitiveType pt : supportedPrimTypes = PrimitiveType.supportedPrimitiveTypes()) {
            primitiveTypeMap.put(pt.primitiveName(), pt);
            wrapperFromStringMap.put(pt.wrapperType(), pt.stringToWrapperF());
        }
        primitiveTypes = primitiveTypeMap.keySet();
        wrapperTypes = primitiveTypeMap.values().stream().map(PrimitiveType::wrapperName).collect(Collectors.toSet());
    }
}

