/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.flows;

import com.simplj.flows.AbstractFlow;
import com.simplj.flows.RetryableFlow;
import com.simplj.flows.core.AbstractStep;
import com.simplj.flows.core.ExecutionContext;
import com.simplj.flows.core.ExecutionResult;
import com.simplj.flows.steps.Step;
import com.simplj.flows.steps.StepFactory;
import com.simplj.lambda.executable.BiExecutable;
import com.simplj.lambda.executable.Executable;
import com.simplj.lambda.executable.Provider;
import com.simplj.lambda.executable.Receiver;
import com.simplj.lambda.function.BiConsumer;
import com.simplj.lambda.function.BiFunction;
import com.simplj.lambda.function.Condition;
import com.simplj.lambda.function.Consumer;
import com.simplj.lambda.function.Function;
import com.simplj.lambda.util.Either;
import com.simplj.lambda.util.retry.RetryContext;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public final class Flow<I, O>
extends AbstractFlow<I, O, Flow<I, O>> {
    private final AbstractStep<I, O> step;

    Flow(AbstractStep<I, O> step) {
        super(Flow.name(step));
        this.step = step;
    }

    public static <T, R> Flow<T, R> lift(Step<T, R> step) {
        return new Flow<T, R>(step);
    }

    public final Flow<Void, O> withInput(I input) {
        return new Flow<I, O>(Flow.connectorStep(this.name, Flow.simpleStep(x -> input), this.step));
    }

    public final <A> Flow<A, O> compose(Function<A, I> f) {
        return new Flow<I, O>(Flow.connectorStep(this.name, Flow.simpleStep(f), this.step));
    }

    public final <A> Flow<I, A> map(Function<O, A> f) {
        return this.join(Flow.simpleStep(f));
    }

    @Override
    public final Flow<I, O> pauseFor(long duration, TimeUnit unit) {
        return this.join(StepFactory.pauseStep(duration, unit));
    }

    @Override
    public final Flow<I, O> pauseWhile(Condition<O> condition) {
        return this.pauseWhile((Condition)condition, TimeUnit.SECONDS.toMillis(1L), -1);
    }

    @Override
    public final Flow<I, O> pauseWhile(Condition<O> condition, long intervalInMillis, int maxWaitTimeInSeconds) {
        return this.join(Flow.pauseStep(condition, intervalInMillis, maxWaitTimeInSeconds));
    }

    @Override
    public final Flow<I, O> pauseUntil(Condition<O> condition) {
        return this.pauseWhile(condition.negate(), TimeUnit.SECONDS.toMillis(1L), -1);
    }

    @Override
    public final Flow<I, O> pauseUntil(Condition<O> condition, long intervalInMillis, int maxWaitTimeInSeconds) {
        return this.join(Flow.pauseStep(condition.negate(), intervalInMillis, maxWaitTimeInSeconds));
    }

    @Override
    public final Flow<I, O> record(Receiver<O> f) {
        return this.join(Step.lift("record", f.yield()));
    }

    @Override
    public final Flow<I, O> record(String name, Receiver<O> f) {
        return this.join(name, Step.lift(name, f.yield()));
    }

    @Override
    public final Flow<I, O> recordIf(Condition<O> condition, Receiver<O> f) {
        return this.when(condition).then(Step.lift("conditional-record", f.yield()));
    }

    @Override
    public final Flow<I, O> recordIf(String name, Condition<O> condition, Receiver<O> f) {
        return this.when(condition).then(Step.lift(name, f.yield()));
    }

    public final <V> Flow<I, V> shift(Provider<V> provider) {
        return this.join(Step.lift(provider));
    }

    public final <V> Flow<I, V> shift(String name, Provider<V> provider) {
        return this.join(Step.lift(name, provider));
    }

    public When when(Condition<O> condition) {
        return new When(condition);
    }

    @Override
    public final Flow<I, O> breakIf(Condition<O> condition, Exception error) {
        return this.join(StepFactory.breakIf(condition, error));
    }

    @Override
    public final Flow<I, O> breakIf(String name, Condition<O> condition, Exception error) {
        return this.join(StepFactory.breakIf(name, condition, error));
    }

    @Override
    public final <X extends Exception> Flow<I, O> breakIf(Condition<O> condition, Function<O, X> errorF) {
        return this.join(StepFactory.breakIf(condition, errorF));
    }

    @Override
    public final <X extends Exception> Flow<I, O> breakIf(String name, Condition<O> condition, Function<O, X> errorF) {
        return this.join(StepFactory.breakIf(name, condition, errorF));
    }

    @Override
    public final Flow<I, O> continueIf(Condition<O> condition, String errorMessage) {
        return this.join(StepFactory.continueIf(condition, errorMessage));
    }

    @Override
    public final Flow<I, O> continueIf(String name, Condition<O> condition, String errorMessage) {
        return this.join(StepFactory.continueIf(name, condition, errorMessage));
    }

    @Override
    public final Flow<I, O> continueIf(Condition<O> condition, Function<O, String> errorF) {
        return this.join(StepFactory.continueIf(condition, errorF));
    }

    @Override
    public final Flow<I, O> continueIf(String name, Condition<O> condition, Function<O, String> errorF) {
        return this.join(StepFactory.continueIf(name, condition, errorF));
    }

    @Override
    public final Flow<I, O> bookmark(Function<I, String> flowNameF, String name, BiExecutable<I, O, O> mergeF) {
        return this.newInstance(Flow.bookmarkStep(flowNameF, name, mergeF, this.step));
    }

    @Override
    public final Flow<I, O> recover(BiExecutable<I, Exception, O> recovery) {
        return this.newInstance(StepFactory.unsafeStep(this.step).recover(null, (Condition<Exception>)Condition.always(), recovery));
    }

    @Override
    public final Flow<I, O> recover(String name, BiExecutable<I, Exception, O> recovery) {
        return this.newInstance(StepFactory.unsafeStep(this.step).recover(name, (Condition<Exception>)Condition.always(), recovery));
    }

    @Override
    public final Flow<I, O> recoverWhen(Condition<Exception> condition, BiExecutable<I, Exception, O> recovery) {
        return this.newInstance(StepFactory.unsafeStep(this.step).recover(null, condition, recovery));
    }

    @Override
    public final Flow<I, O> recoverWhen(String name, Condition<Exception> condition, BiExecutable<I, Exception, O> recovery) {
        return this.newInstance(StepFactory.unsafeStep(this.step).recover(name, condition, recovery));
    }

    @Override
    public final Flow<I, O> recoverOn(String name, Class<? extends Exception> clazz, BiExecutable<I, Exception, O> recovery) {
        return this.newInstance(StepFactory.unsafeStep(this.step).recover(name, (Condition<Exception>)((Condition)e -> clazz.isAssignableFrom(e.getClass())), recovery));
    }

    @Override
    public final Flow<I, O> onError(String name, BiConsumer<I, Exception> handler) {
        return this.newInstance(StepFactory.unsafeStep(this.step).onError(name, handler));
    }

    @Override
    public final Flow<I, O> onSuccessOrError(String name, BiConsumer<I, Either<Exception, O>> handler) {
        return this.newInstance(StepFactory.unsafeStep(this.step).onSuccessOrError(name, handler));
    }

    @Override
    public Flow<I, O> mapError(String name, BiFunction<I, Exception, Exception> mapper) {
        return this.newInstance(StepFactory.unsafeStep(this.step).mapError(name, mapper));
    }

    @Override
    public final <R> Flow<I, O> async(Consumer<O> preHook, AbstractStep<O, R> step, BiConsumer<O, R> postHook, BiConsumer<O, Exception> errNotifier, ExecutorService es) {
        return this.join(StepFactory.asyncStep(preHook, step, postHook, errNotifier, es));
    }

    public final <V> Flow<I, V> then(Executable<? super O, V> executable) {
        return this.join(Step.lift(executable));
    }

    public final <V> Flow<I, V> then(String name, Executable<? super O, V> executable) {
        return this.join(Step.lift(name, executable));
    }

    public final <V> Flow<I, V> flatten(Executable<? super O, AbstractStep<? super O, V>> executable) {
        return this.join(Step.flatten(executable));
    }

    public final <V> Flow<I, V> flatten(String name, Executable<? super O, AbstractStep<? super O, V>> executable) {
        return this.join(Step.flatten(name, executable));
    }

    public final <V> Flow<I, V> join(AbstractStep<? super O, V> next) {
        return this.join(null, next);
    }

    public final <V> Flow<I, V> join(String name, AbstractStep<? super O, V> next) {
        return this.newInstance(Flow.connectorStep(name, this.step, next));
    }

    public final RetryableFlow<I, O> beginRetryableScope(RetryContext retryContext) {
        return new RetryableFlow<I, O>(this.step, retryContext);
    }

    @Override
    protected final ExecutionResult<O> execute(ExecutionContext ctx, I input) {
        return Flow.execute(this.step, input, ctx);
    }

    protected final <V> Flow<I, V> newInstance(AbstractStep<I, V> step) {
        return new Flow<I, V>(step);
    }

    public class When {
        private final Condition<O> condition;

        public When(Condition<O> condition) {
            this.condition = condition;
        }

        public final Flow<I, O> then(Executable<O, O> satisfyBranch) {
            return this.then(Step.lift(satisfyBranch));
        }

        public final Flow<I, O> then(String name, Executable<O, O> satisfyBranch) {
            return this.then(name, Step.lift(satisfyBranch));
        }

        public final Flow<I, O> then(AbstractStep<O, O> satisfyBranch) {
            return Flow.this.join(StepFactory.executeIf(this.condition, satisfyBranch));
        }

        public final Flow<I, O> then(String name, AbstractStep<O, O> satisfyBranch) {
            return Flow.this.join(StepFactory.executeIf(name, this.condition, satisfyBranch));
        }
    }
}

