/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.flows;

import com.simplj.flows.AbstractFlow;
import com.simplj.flows.Flow;
import com.simplj.flows.core.AbstractStep;
import com.simplj.flows.core.ExecutionContext;
import com.simplj.flows.core.ExecutionResult;
import com.simplj.flows.steps.Step;
import com.simplj.flows.steps.StepFactory;
import com.simplj.lambda.executable.BiExecutable;
import com.simplj.lambda.executable.Executable;
import com.simplj.lambda.executable.Provider;
import com.simplj.lambda.executable.Receiver;
import com.simplj.lambda.function.BiConsumer;
import com.simplj.lambda.function.BiFunction;
import com.simplj.lambda.function.Condition;
import com.simplj.lambda.function.Consumer;
import com.simplj.lambda.function.Function;
import com.simplj.lambda.util.Either;
import com.simplj.lambda.util.retry.RetryContext;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public final class RetryableFlow<I, O>
extends AbstractFlow<I, O, RetryableFlow<I, O>> {
    private final AbstractStep<I, O> step;
    private final RetryContext retryContext;

    RetryableFlow(AbstractStep<I, O> step, RetryContext retryContext) {
        super(RetryableFlow.name(step));
        this.step = step;
        this.retryContext = retryContext;
    }

    public final RetryableFlow<Void, O> withInput(I input) {
        return new RetryableFlow<I, O>(RetryableFlow.connectorStep(this.name, RetryableFlow.simpleStep(x -> input), this.step), this.retryContext);
    }

    public final <A> RetryableFlow<A, O> compose(Function<A, I> f) {
        return new RetryableFlow<I, O>(RetryableFlow.connectorStep(this.name, RetryableFlow.simpleStep(f), this.step), this.retryContext);
    }

    public final <A> RetryableFlow<I, A> map(Function<O, A> f) {
        return this.join(RetryableFlow.simpleStep(f));
    }

    @Override
    public final RetryableFlow<I, O> pauseFor(long duration, TimeUnit unit) {
        return this.join(StepFactory.pauseStep(duration, unit));
    }

    @Override
    public final RetryableFlow<I, O> pauseWhile(Condition<O> condition) {
        return this.pauseWhile((Condition)condition, TimeUnit.SECONDS.toMillis(1L), -1);
    }

    @Override
    public final RetryableFlow<I, O> pauseWhile(Condition<O> condition, long intervalInMillis, int maxWaitTimeInSeconds) {
        return this.join(RetryableFlow.pauseStep(condition, intervalInMillis, maxWaitTimeInSeconds));
    }

    @Override
    public final RetryableFlow<I, O> pauseUntil(Condition<O> condition) {
        return this.pauseWhile(condition.negate(), TimeUnit.SECONDS.toMillis(1L), -1);
    }

    @Override
    public final RetryableFlow<I, O> pauseUntil(Condition<O> condition, long intervalInMillis, int maxWaitTimeInSeconds) {
        return this.join(RetryableFlow.pauseStep(condition.negate(), intervalInMillis, maxWaitTimeInSeconds));
    }

    @Override
    public final RetryableFlow<I, O> record(Receiver<O> f) {
        return this.join(Step.lift("record", f.yield()));
    }

    @Override
    public final RetryableFlow<I, O> record(String name, Receiver<O> f) {
        return this.join(name, Step.lift(name, f.yield()));
    }

    @Override
    public final RetryableFlow<I, O> recordIf(Condition<O> condition, Receiver<O> f) {
        return this.when(condition).then(Step.lift("conditional-record", f.yield()));
    }

    @Override
    public final RetryableFlow<I, O> recordIf(String name, Condition<O> condition, Receiver<O> f) {
        return this.when(condition).then(Step.lift(name, f.yield()));
    }

    public final <V> RetryableFlow<I, V> shift(Provider<V> provider) {
        return this.join(Step.lift(provider));
    }

    public final <V> RetryableFlow<I, V> shift(String name, Provider<V> provider) {
        return this.join(Step.lift(name, provider));
    }

    public When when(Condition<O> condition) {
        return new When(condition);
    }

    @Override
    public final RetryableFlow<I, O> breakIf(Condition<O> condition, Exception error) {
        return this.join(StepFactory.breakIf(condition, error));
    }

    @Override
    public final RetryableFlow<I, O> breakIf(String name, Condition<O> condition, Exception error) {
        return this.join(StepFactory.breakIf(name, condition, error));
    }

    @Override
    public final <X extends Exception> RetryableFlow<I, O> breakIf(Condition<O> condition, Function<O, X> errorF) {
        return this.join(StepFactory.breakIf(condition, errorF));
    }

    @Override
    public final <X extends Exception> RetryableFlow<I, O> breakIf(String name, Condition<O> condition, Function<O, X> errorF) {
        return this.join(StepFactory.breakIf(name, condition, errorF));
    }

    @Override
    public final RetryableFlow<I, O> continueIf(Condition<O> condition, String errorMessage) {
        return this.join(StepFactory.continueIf(condition, errorMessage));
    }

    @Override
    public final RetryableFlow<I, O> continueIf(String name, Condition<O> condition, String errorMessage) {
        return this.join(StepFactory.continueIf(name, condition, errorMessage));
    }

    @Override
    public final RetryableFlow<I, O> continueIf(Condition<O> condition, Function<O, String> errorF) {
        return this.join(StepFactory.continueIf(condition, errorF));
    }

    @Override
    public final RetryableFlow<I, O> continueIf(String name, Condition<O> condition, Function<O, String> errorF) {
        return this.join(StepFactory.continueIf(name, condition, errorF));
    }

    @Override
    public final RetryableFlow<I, O> bookmark(Function<I, String> flowNameF, String name, BiExecutable<I, O, O> mergeF) {
        return this.newInstance(RetryableFlow.bookmarkStep(flowNameF, name, mergeF, this.step));
    }

    @Override
    public final RetryableFlow<I, O> recover(BiExecutable<I, Exception, O> recovery) {
        return this.newInstance(StepFactory.unsafeStep(this.step).recover(null, (Condition<Exception>)Condition.always(), recovery));
    }

    @Override
    public final RetryableFlow<I, O> recover(String name, BiExecutable<I, Exception, O> recovery) {
        return this.newInstance(StepFactory.unsafeStep(this.step).recover(name, (Condition<Exception>)Condition.always(), recovery));
    }

    @Override
    public final RetryableFlow<I, O> recoverWhen(Condition<Exception> condition, BiExecutable<I, Exception, O> recovery) {
        return this.newInstance(StepFactory.unsafeStep(this.step).recover(null, condition, recovery));
    }

    @Override
    public final RetryableFlow<I, O> recoverWhen(String name, Condition<Exception> condition, BiExecutable<I, Exception, O> recovery) {
        return this.newInstance(StepFactory.unsafeStep(this.step).recover(name, condition, recovery));
    }

    public final RetryableFlow<I, O> recoverOn(Class<? extends Exception> clazz, BiExecutable<I, Exception, O> recovery) {
        return this.newInstance(StepFactory.unsafeStep(this.step).recover(null, (Condition<Exception>)((Condition)e -> clazz.isAssignableFrom(e.getClass())), recovery));
    }

    @Override
    public final RetryableFlow<I, O> recoverOn(String name, Class<? extends Exception> clazz, BiExecutable<I, Exception, O> recovery) {
        return this.newInstance(StepFactory.unsafeStep(this.step).recover(name, (Condition<Exception>)((Condition)e -> clazz.isAssignableFrom(e.getClass())), recovery));
    }

    @Override
    public final RetryableFlow<I, O> onError(String name, BiConsumer<I, Exception> handler) {
        return this.newInstance(StepFactory.unsafeStep(this.step).onError(name, handler));
    }

    @Override
    public final RetryableFlow<I, O> onSuccessOrError(String name, BiConsumer<I, Either<Exception, O>> handler) {
        return this.newInstance(StepFactory.unsafeStep(this.step).onSuccessOrError(name, handler));
    }

    @Override
    public RetryableFlow<I, O> mapError(String name, BiFunction<I, Exception, Exception> mapper) {
        return this.newInstance(StepFactory.unsafeStep(this.step).mapError(name, mapper));
    }

    @Override
    public final <R> RetryableFlow<I, O> async(Consumer<O> preHook, AbstractStep<O, R> step, BiConsumer<O, R> postHook, BiConsumer<O, Exception> errNotifier, ExecutorService es) {
        return this.join(StepFactory.asyncStep(preHook, step, postHook, errNotifier, es));
    }

    public final <V> RetryableFlow<I, V> then(Executable<? super O, V> executable) {
        return this.join(Step.lift(executable));
    }

    public final <V> RetryableFlow<I, V> then(String name, Executable<? super O, V> executable) {
        return this.join(Step.lift(name, executable));
    }

    public final <V> RetryableFlow<I, V> flatten(Executable<? super O, AbstractStep<? super O, V>> executable) {
        return this.join(Step.flatten(executable));
    }

    public final <V> RetryableFlow<I, V> flatten(String name, Executable<? super O, AbstractStep<? super O, V>> executable) {
        return this.join(Step.flatten(name, executable));
    }

    public final <V> RetryableFlow<I, V> join(AbstractStep<? super O, V> next) {
        return this.join(null, next);
    }

    public final <V> RetryableFlow<I, V> join(String name, AbstractStep<? super O, V> next) {
        AbstractStep<Object, V> retryableNext = RetryableFlow.isMergeable(next) ? next.withRetry(this.retryContext) : StepFactory.retryableStep(next, this.retryContext);
        return this.newInstance(RetryableFlow.connectorStep(name, this.step, retryableNext));
    }

    public final Flow<I, O> endRetryableScope() {
        return new Flow<I, O>(this.step);
    }

    @Override
    protected final ExecutionResult<O> execute(ExecutionContext ctx, I input) {
        return RetryableFlow.execute(this.step, input, ctx);
    }

    protected final <V> RetryableFlow<I, V> newInstance(AbstractStep<I, V> step) {
        return new RetryableFlow<I, V>(step, this.retryContext);
    }

    public class When {
        private final Condition<O> condition;

        public When(Condition<O> condition) {
            this.condition = condition;
        }

        public final RetryableFlow<I, O> then(Executable<O, O> satisfyBranch) {
            return this.then(Step.lift(satisfyBranch));
        }

        public final RetryableFlow<I, O> then(String name, Executable<O, O> satisfyBranch) {
            return this.then(name, Step.lift(satisfyBranch));
        }

        public final RetryableFlow<I, O> then(AbstractStep<O, O> satisfyBranch) {
            return RetryableFlow.this.join(StepFactory.executeIf(this.condition, satisfyBranch));
        }

        public final RetryableFlow<I, O> then(String name, AbstractStep<O, O> satisfyBranch) {
            return RetryableFlow.this.join(StepFactory.executeIf(name, this.condition, satisfyBranch));
        }
    }
}

