/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.flows.core;

import com.simplj.di.core.TypeClass;
import com.simplj.di.exceptions.SdfException;
import com.simplj.flows.core.BookmarkState;
import com.simplj.flows.core.BookmarkStore;
import com.simplj.flows.core.ExecutionContext;
import com.simplj.flows.core.ExecutionResult;
import com.simplj.flows.core.Input;
import com.simplj.flows.core.Session;
import com.simplj.flows.core.SimpleStep;
import com.simplj.flows.core.SjfConfiguration;
import com.simplj.flows.core.SjfUtil;
import com.simplj.flows.core.StepFrame;
import com.simplj.flows.exceptions.DuplicateBookmarkNameException;
import com.simplj.flows.exceptions.FlowBreakException;
import com.simplj.flows.exceptions.FlowConstructException;
import com.simplj.flows.exceptions.SjfException;
import com.simplj.flows.steps.BookmarkStep;
import com.simplj.flows.steps.ConnectorStep;
import com.simplj.flows.steps.PauseStep;
import com.simplj.lambda.executable.BiExecutable;
import com.simplj.lambda.executable.Executable;
import com.simplj.lambda.function.Condition;
import com.simplj.lambda.function.Function;
import com.simplj.lambda.util.Either;
import com.simplj.lambda.util.retry.RetryContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public abstract class AbstractStep<I, O> {
    protected final String name;

    protected AbstractStep(String name) {
        this.name = name;
    }

    protected static <T, R> String name(AbstractStep<T, R> step) {
        return step.name();
    }

    protected String name() {
        return this.name;
    }

    protected static <T, R> boolean isMergeable(AbstractStep<T, R> step) {
        return step.isMergeable();
    }

    protected static <T, R> ExecutionResult<R> execute(AbstractStep<T, R> step, T input, ExecutionContext ctx) {
        return step.execute(ctx, input);
    }

    protected static <T, R> ExecutionResult<R> execute(Executable<T, R> executable, T input, ExecutionContext ctx, String name) {
        ExecutionResult<Object> res;
        Input inp = Input.of(input);
        long s = System.currentTimeMillis();
        try {
            ctx.applyPreHooks(name, inp);
            Object r = executable.execute(input);
            StepFrame stepFrame = new StepFrame(name, inp, r, System.currentTimeMillis() - s);
            ctx.applyPostHooks(stepFrame);
            res = new ExecutionResult<Object>(r, ctx.add(stepFrame));
        }
        catch (Exception e) {
            res = new ExecutionResult(e, ctx.add(StepFrame.error(name, inp, e, System.currentTimeMillis() - s)));
            SjfConfiguration.configuredInstance().notifyError(e);
        }
        return res;
    }

    protected static <T, R> ExecutionResult<R> execute(Function<T, Either<Exception, R>> executable, T input, ExecutionContext ctx, String name) {
        ExecutionResult<Object> res;
        Input inp = Input.of(input);
        long s = System.currentTimeMillis();
        ctx.applyPreHooks(name, inp);
        Either r = (Either)executable.apply(input);
        long e = System.currentTimeMillis();
        if (r.isRight()) {
            StepFrame stepFrame = new StepFrame(name, inp, (Object)r, e - s);
            ctx.applyPostHooks(stepFrame);
            res = new ExecutionResult<Object>(r.right(), ctx.add(stepFrame));
        } else {
            res = new ExecutionResult((Exception)r.left(), ctx.add(StepFrame.error(name, inp, (Exception)r.left(), e - s)));
        }
        return res;
    }

    protected static <T, R> ExecutionResult<R> flatExecute(Executable<? super T, AbstractStep<? super T, R>> executable, T input, ExecutionContext ctx, String name) {
        ExecutionResult<Object> res;
        Input inp = Input.of(input);
        long s = System.currentTimeMillis();
        try {
            ctx.applyPreHooks(name, inp);
            AbstractStep step = (AbstractStep)executable.execute(input);
            ExecutionResult r = step.execute(ctx.copy(null), input);
            long e = System.currentTimeMillis();
            if (r.isSuccess()) {
                StepFrame stepFrame = new StepFrame(name, inp, r, e - s);
                ctx.applyPostHooks(stepFrame);
            }
            res = new ExecutionResult(r.result(), r.error(), ctx.add(new StepFrame(name, inp, r.executionContext().frames(), r, e - s)));
        }
        catch (Exception e) {
            res = new ExecutionResult(e, ctx.add(StepFrame.error(name, inp, e, System.currentTimeMillis() - s)));
            SjfConfiguration.configuredInstance().notifyError(e);
        }
        return res;
    }

    protected static <A, B, R> ExecutionResult<R> execute(BiExecutable<A, B, R> executable, A inpA, B inpB, ExecutionContext ctx, String name) {
        ExecutionResult<Object> res;
        Input inp = Input.of(inpA, inpB);
        long s = System.currentTimeMillis();
        try {
            Object r = executable.execute(inpA, inpB);
            res = new ExecutionResult<Object>(r, ctx.add(new StepFrame(name, inp, r, System.currentTimeMillis() - s)));
        }
        catch (Exception e) {
            res = new ExecutionResult(e, ctx.add(StepFrame.error(name, inp, e, System.currentTimeMillis() - s)));
        }
        return res;
    }

    protected static <A> ExecutionResult<Boolean> evaluate(String name, Condition<A> condition, A input, ExecutionContext ctx) {
        ExecutionResult<Boolean> res;
        Input inp = Input.of(input);
        long s = System.currentTimeMillis();
        try {
            boolean flag = condition.evaluate(input);
            res = new ExecutionResult<Boolean>(flag, ctx.add(new StepFrame(name, inp, (Object)flag, System.currentTimeMillis() - s)));
        }
        catch (Exception e) {
            res = new ExecutionResult<Boolean>(e, ctx.add(StepFrame.error(name, inp, e, System.currentTimeMillis() - s)));
        }
        return res;
    }

    protected static StepFrame stepFrame(String name, String msg) {
        return new StepFrame(name, msg, -1L);
    }

    protected static StepFrame stepFrame(String name, String msg, long duration) {
        return new StepFrame(name, msg, duration);
    }

    protected static StepFrame stepFrame(String name, String msg, Object output, long duration) {
        return new StepFrame(name, msg, output, duration);
    }

    protected static StepFrame stepFrame(String name, Input input, Object output, long duration) {
        return new StepFrame(name, input, output, duration);
    }

    protected static StepFrame stepFrame(String name, Input input, List<StepFrame> subSteps, Object output, long duration) {
        return new StepFrame(name, input, subSteps, output, duration);
    }

    protected static StepFrame errStepFrame(String name, Input input, Exception error, long duration) {
        return StepFrame.error(name, input, error, duration);
    }

    protected static <T> ExecutionResult<T> success(T result, ExecutionContext ctx) {
        return new ExecutionResult<T>(result, ctx);
    }

    protected static <T> ExecutionResult<T> error(Exception error, ExecutionContext ctx) {
        return new ExecutionResult(error, ctx);
    }

    protected static <T> ExecutionResult<T> executionResult(T result, Exception error, ExecutionContext ctx) {
        return new ExecutionResult<T>(result, error, ctx);
    }

    protected static <T> T dynamicResolve(TypeClass<T> typeClass, Map<String, Object> params) {
        if (SjfConfiguration.isConfigured()) {
            Object res = SjfConfiguration.configuredInstance().getDependencyResolver().dynamicResolve(typeClass, params);
            if (res == null) {
                throw new SdfException("Sjf not configured! Hint: Configure SJF with default configuration 'SjfConfiguration.defaultConfiguration().configure()' beforehand.");
            }
            return (T)res;
        }
        throw new SjfException("SJF is not configured!");
    }

    protected static <T> T dynamicResolve(String id, TypeClass<T> typeClass, Map<String, Object> params) {
        if (SjfConfiguration.isConfigured()) {
            Object res = SjfConfiguration.configuredInstance().getDependencyResolver().dynamicResolve(id, typeClass, params);
            if (res == null) {
                throw new SdfException("Sjf not configured! Hint: Configure SJF with default configuration 'SjfConfiguration.defaultConfiguration().configure()' beforehand,");
            }
            return (T)res;
        }
        throw new SjfException("SJF is configured!");
    }

    protected static <T> PauseStep<T> pauseStep(Condition<T> condition, long intervalInMillis, int maxWaitTimeInSeconds) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("condition", condition);
        params.put("intervalMillis", intervalInMillis);
        params.put("maxWaitSecs", maxWaitTimeInSeconds);
        try {
            return (PauseStep)AbstractStep.dynamicResolve(new TypeClass<PauseStep<T>>(){}, params);
        }
        catch (ClassNotFoundException e) {
            throw new FlowConstructException("Failed to construct pause step! Please contact SJF Team. Error: " + e.getMessage());
        }
    }

    protected static <A, B, C> ConnectorStep<A, B, C> connectorStep(String name, AbstractStep<A, B> before, AbstractStep<? super B, C> after) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", name);
        params.put("before", before);
        params.put("after", after);
        try {
            return (ConnectorStep)AbstractStep.dynamicResolve(new TypeClass<ConnectorStep<A, B, C>>(){}, params);
        }
        catch (SdfException | ClassNotFoundException e) {
            if (e.getCause() != null && e.getCause() instanceof DuplicateBookmarkNameException) {
                DuplicateBookmarkNameException de = (DuplicateBookmarkNameException)e.getCause();
                throw new DuplicateBookmarkNameException(de.getBookmarkName(), de.getMessage());
            }
            throw new FlowConstructException("Failed to construct join step! Please contact SJF Team. Error: " + e.getMessage());
        }
    }

    protected static <A, B> BookmarkStep<A, B> bookmarkStep(Function<A, String> flowNameF, String name, BiExecutable<A, B, B> mergeF, AbstractStep<A, B> step) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("flowNameF", flowNameF);
        params.put("name", name);
        params.put("mergeF", mergeF);
        params.put("step", step);
        try {
            return (BookmarkStep)AbstractStep.dynamicResolve(new TypeClass<BookmarkStep<A, B>>(){}, params);
        }
        catch (SdfException | ClassNotFoundException e) {
            if (e.getCause() != null && e.getCause() instanceof DuplicateBookmarkNameException) {
                DuplicateBookmarkNameException de = (DuplicateBookmarkNameException)e.getCause();
                throw new DuplicateBookmarkNameException(de.getBookmarkName(), de.getMessage());
            }
            throw new FlowConstructException("Failed to construct bookmark step! Please contact SJF Team. Error: " + e.getMessage());
        }
    }

    protected static <T, R> SimpleStep<T, R> simpleStep(Function<T, R> f) {
        return new SimpleStep<T, R>(f);
    }

    protected static BookmarkStore getBookmarkStore() {
        return BookmarkStore.getBookmarkStore();
    }

    protected static BookmarkStore getBookmarkStore(ExecutionContext ctx, BookmarkStore defaultStore) {
        return Optional.ofNullable(ctx.getBookmarkStore()).orElse(defaultStore);
    }

    protected static int validateUniqueness(BookmarkStore store, ExecutionContext ctx, String fqBm) {
        return store.validateUniqueness(ctx, fqBm);
    }

    protected static BookmarkState retrieve(BookmarkStore store, ExecutionContext ctx, String flowName) throws Exception {
        return store.retrieve(ctx, flowName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <O> ExecutionResult<O> save(ExecutionContext ctx, BookmarkStore store, String flowName, String bookmarkName, String fqBm, ExecutionResult<O> res) {
        ExecutionResult<O> eRes;
        Object object = ctx.getLock();
        synchronized (object) {
            eRes = store.save(ctx, flowName, bookmarkName, fqBm, res);
        }
        return eRes;
    }

    protected static void cleanup(BookmarkStore store, String id, String bm) {
        store.clear(id, bm);
    }

    protected static Session session() {
        return Session.current();
    }

    protected static ExecutionContext copy(ExecutionContext ctx, Session session) {
        return ctx.copy(session);
    }

    protected static void setVar(ExecutionContext ctx, String key, Object val) {
        ctx.setVar(key, val);
    }

    protected static <T> T getVar(ExecutionContext ctx, String key, Class<T> type, T defaultVal) {
        return ctx.getVar(key, type, defaultVal);
    }

    protected static boolean notFlowBreak(Exception ex) {
        boolean flag = ex instanceof FlowBreakException || ex instanceof SjfException;
        return !flag;
    }

    protected static List<StepFrame> stepFrames(ExecutionContext ctx) {
        return ctx.frames();
    }

    protected static ExecutionContext addFrame(ExecutionContext ctx, StepFrame frame) {
        return ctx.add(frame);
    }

    protected static ExecutionContext merge(ExecutionContext source, ExecutionContext from, boolean isNew) {
        from.frames().get(0).setFirst(isNew);
        return source.mergeFrames(from);
    }

    protected static void log(ExecutionContext ctx, String msg) {
        ctx.getLogger().consume((Object)msg);
    }

    protected static <T> void conditionalPause(Condition<T> pauseCondition, T input, long maxWaitTimeMillis, long pauseIntervalMillis) {
        Condition condition;
        if (maxWaitTimeMillis > 0L) {
            long endTime = System.currentTimeMillis() + maxWaitTimeMillis;
            condition = v -> pauseCondition.evaluate(v) && System.currentTimeMillis() < endTime;
        } else {
            condition = pauseCondition;
        }
        while (condition.evaluate(input)) {
            AbstractStep.pause(pauseIntervalMillis);
        }
    }

    protected static void pause(long timeToSleep) {
        SjfUtil.sleep(timeToSleep);
    }

    protected boolean isMergeable() {
        return false;
    }

    public AbstractStep<I, O> withRetry(RetryContext retryContext) {
        return this;
    }

    protected abstract ExecutionResult<O> execute(ExecutionContext var1, I var2);
}

