/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.flows.core;

import com.simplj.flows.core.Bookmark;
import com.simplj.flows.core.BookmarkKeys;
import com.simplj.flows.core.BookmarkState;
import com.simplj.flows.core.ExecutionContext;
import com.simplj.flows.core.ExecutionResult;
import com.simplj.flows.core.Input;
import com.simplj.flows.core.Session;
import com.simplj.flows.core.SjfConfiguration;
import com.simplj.flows.core.StepFrame;
import com.simplj.lambda.data.Util;
import com.simplj.lambda.util.Either;
import com.simplj.lambda.util.Try;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public abstract class BookmarkStore {
    private final Map<String, Bookmark> bookmarks = new ConcurrentHashMap<String, Bookmark>();
    private final Map<String, BookmarkKeys> idBookmarkMap = new ConcurrentHashMap<String, BookmarkKeys>();

    protected BookmarkStore() {
    }

    public abstract String type();

    public abstract void set(String var1, Bookmark var2) throws Exception;

    public abstract Bookmark get(String var1, Bookmark var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] serialize(Bookmark obj) throws IOException {
        byte[] res;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(obj);
            out.flush();
            res = bos.toByteArray();
        }
        finally {
            Try.execute(bos::close).run();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Bookmark deserialize(byte[] bytes) throws IOException, ClassNotFoundException {
        Bookmark res;
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        try {
            ObjectInputStream in = new ObjectInputStream(bis);
            res = (Bookmark)Util.cast((Object)in.readObject());
        }
        finally {
            Try.execute(bis::close).run();
        }
        return res;
    }

    int validateUniqueness(ExecutionContext ctx, String fqBm) {
        BookmarkKeys b = this.idBookmarkMap.computeIfAbsent(ctx.idempotentId(), x -> new BookmarkKeys(ctx.executionId(), fqBm));
        int r = ctx.executionId().equals(b.id()) ? (b.isUniqueFqBm(fqBm) ? 0 : 1) : 2;
        return r;
    }

    BookmarkState retrieve(ExecutionContext ctx, String flowName) throws Exception {
        BookmarkState state = this.retrieve(ctx).getState(flowName);
        if (state != null) {
            Session.update(state.session());
        }
        return state;
    }

    Bookmark retrieve(ExecutionContext ctx) throws Exception {
        String id = ctx.idempotentId();
        Bookmark bm = this.bookmarks.get(id);
        if (bm == null) {
            bm = this.get(id, new Bookmark()).updateTransientFields(ctx);
            bm = Optional.ofNullable(this.bookmarks.putIfAbsent(id, bm)).orElse(bm);
        }
        return bm;
    }

    <O> ExecutionResult<O> save(ExecutionContext ctx, String flowName, String bookmarkName, String fqBm, ExecutionResult<O> res) {
        long s = System.currentTimeMillis();
        Either e = Try.execute(() -> this.retrieve(ctx)).result();
        if (e.isRight()) {
            Bookmark bookmark = (Bookmark)e.right();
            bookmark.updateState(flowName, new BookmarkState(bookmarkName, res.result(), ctx.add(new StepFrame(fqBm, res.result() == null ? "WARNING: Bookmarked NULL value!" : "Bookmarked value!", System.currentTimeMillis() - s)), Session.current()));
            try {
                Bookmark r = this.bookmarks.putIfAbsent(ctx.idempotentId(), bookmark);
                if (r != bookmark) {
                    SjfConfiguration.configuredInstance().defaultLogger().consume((Object)"[SJF-ERROR] Bookmarks do not match!");
                }
                this.set(ctx.idempotentId(), bookmark);
            }
            catch (Exception ex) {
                res = new ExecutionResult(ex, ctx.add(StepFrame.error(flowName + "-bookmark", Input.of(ctx.idempotentId()), ex, -1L)));
            }
        } else {
            res = new ExecutionResult((Exception)e.left(), ctx.add(StepFrame.error(flowName + "-bookmark-get", Input.of(ctx.idempotentId()), (Exception)e.left(), -1L)));
        }
        return res;
    }

    void clear(String id, String bm) {
        Optional.ofNullable(this.idBookmarkMap.get(id)).filter(b -> b.lastBookmarkName().equals(bm)).ifPresent(x -> {
            this.bookmarks.remove(id);
            this.idBookmarkMap.remove(id);
        });
    }

    static BookmarkStore getBookmarkStore() {
        return SjfConfiguration.configuredInstance().getBookmarkStore();
    }
}

