/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.flows.core;

import com.simplj.di.internal.TypeUtil;
import com.simplj.flows.core.BookmarkStore;
import com.simplj.flows.core.Input;
import com.simplj.flows.core.Session;
import com.simplj.flows.core.SjfUtil;
import com.simplj.flows.core.StepFrame;
import com.simplj.flows.core.ThreadSafeList;
import com.simplj.lambda.function.BiConsumer;
import com.simplj.lambda.function.Consumer;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public final class ExecutionContext
implements Serializable {
    private final String executionId;
    private final String idempotentId;
    private transient Object lock;
    private transient Consumer<String> logger;
    private transient List<BiConsumer<String, Input>> preHooks;
    private transient List<Consumer<StepFrame>> postHooks;
    private transient BookmarkStore bookmarkStore;
    private final Map<String, Object> vars;
    private List<StepFrame> stepFrames;

    ExecutionContext(Consumer<String> logger, List<BiConsumer<String, Input>> preHooks, List<Consumer<StepFrame>> postHooks) {
        this(null, logger, preHooks, postHooks, null);
    }

    ExecutionContext(Consumer<String> logger, List<BiConsumer<String, Input>> preHooks, List<Consumer<StepFrame>> postHooks, BookmarkStore store) {
        this(null, logger, preHooks, postHooks, store);
    }

    ExecutionContext(String idempotentId, Consumer<String> logger, List<BiConsumer<String, Input>> preHooks, List<Consumer<StepFrame>> postHooks) {
        this(idempotentId, logger, preHooks, postHooks, null);
    }

    ExecutionContext(String idempotentId, Consumer<String> logger, List<BiConsumer<String, Input>> preHooks, List<Consumer<StepFrame>> postHooks, BookmarkStore store) {
        this(UUID.randomUUID().toString(), idempotentId, new Object(), logger, preHooks, postHooks, store, new ConcurrentHashMap<String, Object>());
    }

    private ExecutionContext(String id, String idempotentId, Object lock, Consumer<String> logger, List<BiConsumer<String, Input>> preHooks, List<Consumer<StepFrame>> postHooks, BookmarkStore store, Map<String, Object> varMap, Session session) {
        this(id, idempotentId, lock, logger, preHooks, postHooks, store, varMap);
        Session.set(session);
    }

    private ExecutionContext(String id, String idempotentId, Object lock, Consumer<String> logger, List<BiConsumer<String, Input>> preHooks, List<Consumer<StepFrame>> postHooks, BookmarkStore store, Map<String, Object> varMap) {
        this.executionId = id;
        this.idempotentId = Optional.ofNullable(idempotentId).filter(SjfUtil::isNotBlank).orElse(UUID.randomUUID().toString());
        this.lock = lock;
        this.logger = logger;
        this.preHooks = preHooks;
        this.postHooks = postHooks;
        this.bookmarkStore = store;
        this.vars = varMap;
        this.stepFrames = new ThreadSafeList<StepFrame>();
    }

    public String executionId() {
        return this.executionId;
    }

    public final String idempotentId() {
        return this.idempotentId;
    }

    final Object getLock() {
        return this.lock;
    }

    final Consumer<String> getLogger() {
        return this.logger;
    }

    final BookmarkStore getBookmarkStore() {
        return this.bookmarkStore;
    }

    final ExecutionContext copy(Session session) {
        return new ExecutionContext(this.executionId, this.idempotentId, this.lock, this.logger, this.preHooks, this.postHooks, this.bookmarkStore, this.vars, session);
    }

    final void updateTransientFields(ExecutionContext ctx) {
        this.lock = ctx.lock;
        this.logger = ctx.logger;
        this.preHooks = ctx.preHooks;
        this.postHooks = ctx.postHooks;
        this.bookmarkStore = ctx.bookmarkStore;
    }

    final void setVar(String key, Object val) {
        this.vars.put(key, val);
    }

    final <T> T getVar(String key, Class<T> type, T defaultVal) {
        Object res = defaultVal;
        Object val = this.vars.get(key);
        if (val != null) {
            res = TypeUtil.typeCast(type, (Object)val);
        }
        return res;
    }

    final List<StepFrame> frames() {
        return this.stepFrames;
    }

    final ExecutionContext add(StepFrame frame) {
        if (this.stepFrames.isEmpty()) {
            frame.setFirst(true);
        }
        this.stepFrames.add(frame);
        return this;
    }

    final ExecutionContext mergeFrames(ExecutionContext that) {
        if (this.stepFrames.size() > that.stepFrames.size()) {
            this.stepFrames.addAll(that.stepFrames);
        } else {
            that.stepFrames.addAll(0, this.stepFrames);
            this.stepFrames = that.stepFrames;
        }
        return this;
    }

    final void applyPreHooks(String name, Input input) {
        this.preHooks.forEach(c -> c.consume((Object)name, (Object)input));
    }

    final void applyPostHooks(StepFrame stepFrame) {
        this.postHooks.forEach(c -> c.consume((Object)stepFrame));
    }
}

