/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.flows.core;

import com.simplj.flows.core.AbstractStep;
import com.simplj.flows.core.BookmarkStore;
import com.simplj.flows.core.ExecutionContext;
import com.simplj.flows.core.ExecutionResult;
import com.simplj.flows.core.Input;
import com.simplj.flows.core.StepFrame;
import com.simplj.lambda.function.BiConsumer;
import com.simplj.lambda.function.Consumer;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public final class ExecutionEngine {
    private final Consumer<String> logger;
    private final List<BiConsumer<String, Input>> preHooks;
    private final List<Consumer<StepFrame>> postHooks;

    private ExecutionEngine(Consumer<String> logger, List<BiConsumer<String, Input>> preHooks, List<Consumer<StepFrame>> postHooks) {
        this.logger = Optional.ofNullable(logger).orElse((Consumer<String>)((Consumer)System.out::println));
        this.preHooks = preHooks;
        this.postHooks = postHooks;
    }

    public static ExecutionEngineBuilder custom() {
        return new ExecutionEngineBuilder();
    }

    public static ExecutionEngine defaultEngine() {
        return ExecutionEngine.custom().getEngine();
    }

    public final <I, O> ExecutionResult<O> execute(AbstractStep<I, O> step, I input) {
        return step.execute(new ExecutionContext(this.logger, this.preHooks, this.postHooks), input);
    }

    public final <I, O> ExecutionResult<O> execute(BookmarkStore bookmarkStore, AbstractStep<I, O> step, I input) {
        return step.execute(new ExecutionContext(this.logger, this.preHooks, this.postHooks, bookmarkStore), input);
    }

    public final <I, O> ExecutionResult<O> execute(AbstractStep<I, O> step, I input, String idempotentId) {
        return step.execute(new ExecutionContext(idempotentId, this.logger, this.preHooks, this.postHooks), input);
    }

    public final <I, O> ExecutionResult<O> execute(BookmarkStore bookmarkStore, AbstractStep<I, O> step, I input, String idempotentId) {
        return step.execute(new ExecutionContext(idempotentId, this.logger, this.preHooks, this.postHooks, bookmarkStore), input);
    }

    public static final class ExecutionEngineBuilder {
        private Consumer<String> logger;
        private final List<BiConsumer<String, Input>> preHooks = new LinkedList<BiConsumer<String, Input>>();
        private final List<Consumer<StepFrame>> postHooks = new LinkedList<Consumer<StepFrame>>();

        public final ExecutionEngineBuilder withLogger(Consumer<String> logger) {
            this.logger = logger;
            return this;
        }

        public final ExecutionEngineBuilder addPreHooks(BiConsumer<String, Input> preHook) {
            this.preHooks.add(preHook);
            return this;
        }

        public final ExecutionEngineBuilder addPostHooks(Consumer<StepFrame> postHook) {
            this.postHooks.add(postHook);
            return this;
        }

        public final ExecutionEngine getEngine() {
            return new ExecutionEngine(this.logger, this.preHooks, this.postHooks);
        }
    }
}

