/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.flows.core;

import com.simplj.flows.core.ExecutionContext;
import com.simplj.flows.core.HtmlUtil;
import com.simplj.flows.core.StepFrame;
import com.simplj.lambda.executable.Executable;
import com.simplj.lambda.function.Condition;
import com.simplj.lambda.function.Consumer;
import com.simplj.lambda.function.Function;
import com.simplj.lambda.monadic.exception.FilteredOutException;
import com.simplj.lambda.util.Either;
import com.simplj.lambda.util.Try;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class ExecutionResult<T> {
    private final T result;
    private final Exception error;
    private final ExecutionContext ctx;

    ExecutionResult(T result, ExecutionContext ctx) {
        this(result, null, ctx);
    }

    ExecutionResult(Exception error, ExecutionContext ctx) {
        this(null, error, ctx);
    }

    ExecutionResult(T result, Exception error, ExecutionContext ctx) {
        this.result = result;
        this.error = error;
        this.ctx = ctx;
    }

    public static <E> ExecutionResult<E> failure(String error) {
        return ExecutionResult.failure(new Exception(error));
    }

    public static <E> ExecutionResult<E> failure(Exception ex) {
        return new ExecutionResult(ex, new ExecutionContext((Consumer<String>)Consumer.noOp(), Collections.emptyList(), Collections.emptyList()));
    }

    public final <V> ExecutionResult<V> map(Executable<T, V> executable) {
        return this.flatmap(t -> new ExecutionResult<Object>(executable.execute(t), this.ctx));
    }

    public final ExecutionResult<T> mapError(Function<Exception, Exception> mapper) {
        return this.isSuccess() ? this : new ExecutionResult<Object>(null, (Exception)mapper.apply((Object)this.error), this.ctx);
    }

    public final <V> ExecutionResult<V> flatmap(Executable<T, ExecutionResult<V>> executable) {
        ExecutionResult res = this.isSuccess() ? (ExecutionResult)Try.execute(() -> (ExecutionResult)executable.execute(this.result)).recover(e -> new ExecutionResult<Object>(null, (Exception)e, this.ctx)).result().right() : new ExecutionResult(null, this.error, this.ctx);
        return res;
    }

    public final ExecutionResult<T> filter(Condition<T> c) {
        return !this.isSuccess() || c.evaluate(this.result) ? this : new ExecutionResult<Object>(null, (Exception)new FilteredOutException(this.result), this.ctx);
    }

    public final boolean isSuccess() {
        return this.error == null;
    }

    public final boolean isFailure() {
        return this.error != null;
    }

    public final T result() {
        return this.result;
    }

    public final Exception error() {
        return this.error;
    }

    public final Either<Exception, T> resultOrError() {
        return Optional.ofNullable(this.error).map(Either::left).orElse(Either.right(this.result));
    }

    public final ExecutionContext executionContext() {
        return this.ctx;
    }

    public final String toString() {
        return this.isSuccess() ? String.format("Success[%s :: %s]", this.result, this.result.getClass().getTypeName()) : String.format("Failure[Error: %s]", this.error.getMessage());
    }

    public final void printExecution(Consumer<String> loggerF) {
        loggerF.consume((Object)"Flow Execution:");
        this.printFrameDetails("", this.ctx.frames(), loggerF);
    }

    public final String getExecutionAsJson() {
        return String.format("[%s]", this.ctx.frames().stream().map(StepFrame::toJsonString).collect(Collectors.joining(",")));
    }

    public final String getExecutionAsHtml() {
        return HtmlUtil.renderHtml(this.ctx.frames(), true);
    }

    public final void recordExecution(Consumer<List<StepFrame>> loggerF) {
        loggerF.consume(this.ctx.frames());
    }

    private void printFrameDetails(String space, List<StepFrame> stepFrames, Consumer<String> loggerF) {
        for (StepFrame frame : stepFrames) {
            loggerF.consume((Object)(space + (frame.isFirst() ? " +- " : " |- ") + frame));
            if (frame.subFrames().isEmpty()) continue;
            this.printFrameDetails(space + "  ", frame.subFrames(), loggerF);
        }
    }
}

