/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.flows.core;

import com.simplj.flows.core.StepFrame;
import java.util.List;
import java.util.Optional;

final class HtmlUtil {
    private static final int TD_CONTENT_MAX_LENGTH = 40;
    private static final int TD_CONTENT_TRIM_LENGTH = 37;
    private static final String HEAD = "<html><head><style>\n.flow  {overflow: auto;width: 80%;margin-left: auto;margin-right: auto;}\n.flow table {border: .5px solid #475947;height: auto;width: 100%;table-layout: fixed;border-collapse: collapse;border-spacing: 1px;text-align: left;}\n.header {background-color: #919da1;color: #FFFFFF;padding: 5px;}\n.collapsible {background-color: #94e3a3;color: #075c01;padding: 5px;cursor: pointer;}\n.first-collapsible {background-color: #94e3a3;color: #075c01;padding: 5px;border-left: 5px ridge #5d9467;cursor: pointer;}\n.error-collapsible {background-color: #db8f8f;color: #075c01;padding: 5px;cursor: pointer;}\n.error-first-collapsible {background-color: #db8f8f;color: #075c01;padding: 5px;border-left: 5px ridge #5d9467;cursor: pointer;}\n.active, .collapsible:hover {background-color: #c6fc03;}\n.active, .first-collapsible:hover {background-color: #c6fc03;}\n.active, .error-collapsible:hover {background-color: #c6fc03;}\n.active, .error-first-collapsible:hover {background-color: #c6fc03;}\n.row {background-color: #a1f7b1;color: #075c01;padding: 5px;}\n.first-row1 {background-color: #a1f7b1;color: #075c01;padding: 5px;border-left: 5px ridge #5d9467;}\n.first-row {background: linear-gradient(to bottom, #6bc77c 0%, #a1f7b1 100%);color: #075c01;padding: 5px;border-left: 5px ridge #5d9467;}\n.error-row {background-color: #f7a1a1;color: #075c01;padding: 5px;}\n.error-first-row {background: linear-gradient(to bottom, #c46868 0%, #f7a1a1 100%);color: #075c01;padding: 5px;border-left: 5px ridge #5d9467;}\n.hidden-row {display: none;overflow: auto;}\n.th-name {border: .5px solid #475947;width: 20%;padding: 5px;}\n.th-main {border: .5px solid #475947;width: 35%;padding: 5px;}\n.th-time {border: .5px solid #475947;width: 10%;padding: 5px;}\n.td-name {border: .5px solid #475947;width: 20%;padding: 5px;white-space: nowrap;overflow: hidden;text-overflow: ellipsis;}\n.td-main {border: .5px solid #475947;width: 35%;padding: 5px;white-space: nowrap;overflow: hidden;}\n.td-time {border: .5px solid #475947;width: 10%;padding: 5px;}\n.sub-spacing {margin-left: 5px;}\n.tooltiptext {visibility: hidden;width: auto;background-color: #fef295;color: #735c00;border-radius: 6px;padding: 5px;white-space: pre-wrap;position: absolute;z-index: 1;}\n.td-main:hover .tooltiptext {visibility: visible;}</style></head><body>";
    private static final String TABLE_HEADER = "\n<tr class=\"header\">\n<td class=\"header-name\">Name</td>\n<td class=\"header-main\">Input</td>\n<td class=\"header-main\">Output</td>\n<td class=\"header-time\">Duration</td>\n</tr>";
    private static final String BODY = "\n<script>\nvar coll = document.getElementsByTagName(\"tr\");\nvar i;\nfor (i = 0; i < coll.length; i++) {\n  if (coll[i].className.endsWith(\"collapsible\")) {\n    coll[i].addEventListener(\"click\", function() {\n      //this.classList.toggle(\"active\");\n      var content = this.nextElementSibling;\n      if (content.style.display === \"table-row\") {\n        content.style.display = \"none\";\n      } else {\n        content.style.display = \"table-row\";\n      }\n    });\n  }\n}\n</script>\n</body></html>";

    HtmlUtil() {
    }

    static String renderHtml(List<StepFrame> frames, boolean outer) {
        if (frames.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (outer) {
            sb.append("\n<div class=\"flow\" role=\"region\" tabindex=\"0\">\n<table>\n<tbody>");
        } else {
            sb.append("\n<tr class=\"hidden-row\">\n<td colspan=\"4\">\n<div class=\"sub-spacing\">\n<table>\n<tbody>");
        }
        sb.append(TABLE_HEADER);
        for (StepFrame frame : frames) {
            if (frame.subFrames().isEmpty()) {
                sb.append("\n<tr class=\"").append(HtmlUtil.cssPrefix(frame)).append("row\">");
            } else {
                sb.append("\n<tr class=\"").append(HtmlUtil.cssPrefix(frame)).append("collapsible\">");
            }
            sb.append("\n<td class=\"").append("td-name\">").append(frame.name()).append("</td>");
            if (frame.duration() < 0L) {
                if (frame.msg() != null && frame.output() == null) {
                    sb.append("\n<td class=\"").append("td-main\" colspan=\"3\">").append(HtmlUtil.taut(frame.msg())).append("</td>");
                } else {
                    sb.append("\n<td class=\"").append("td-main\">").append(HtmlUtil.taut(Optional.ofNullable(frame.input()).orElse(frame.msg()))).append("</td>");
                    sb.append("\n<td class=\"").append("td-main\" colspan=\"2\">").append(HtmlUtil.taut(Optional.ofNullable(frame.errorTraceString()).orElse(frame.output()))).append("</td>");
                }
            } else {
                if (frame.msg() != null && frame.output() == null) {
                    sb.append("\n<td class=\"").append("td-main\" colspan=\"2\">").append(HtmlUtil.taut(frame.msg())).append("</td>");
                } else {
                    sb.append("\n<td class=\"").append("td-main\">").append(HtmlUtil.taut(Optional.ofNullable(frame.input()).orElse(frame.msg()))).append("</td>");
                    sb.append("\n<td class=\"").append("td-main\">").append(HtmlUtil.taut(Optional.ofNullable(frame.errorTraceString()).orElse(frame.output()))).append("</td>");
                }
                sb.append("\n<td class=\"").append("td-time\">").append(frame.formattedDuration()).append("</td>");
            }
            sb.append(HtmlUtil.renderHtml(frame.subFrames(), false));
            sb.append("\n</tr>");
        }
        if (outer) {
            sb.append("\n</tbody>\n</table>\n</div>");
        } else {
            sb.append("\n</tbody>\n</table>\n</div>\n</td>\n</tr>");
        }
        String res = outer ? HEAD + sb + BODY : sb.toString();
        return res;
    }

    private static String cssPrefix(StepFrame frame) {
        String res = frame.isError() ? (frame.isFirst() ? "error-first-" : "error-") : (frame.isFirst() ? "first-" : "");
        return res;
    }

    private static String taut(String str) {
        String res = str == null ? "null" : (str.length() > 40 ? str.substring(0, 37) + "...<span class=\"tooltiptext\">" + str + "</span>" : str);
        return res;
    }
}

