/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.flows.core;

import com.simplj.flows.core.Bookmark;
import com.simplj.flows.core.BookmarkStore;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class InMemoryBookmark
extends BookmarkStore {
    private static final InMemoryBookmark instance = new InMemoryBookmark();
    private final Map<String, Bookmark> inMemoryStore = new ConcurrentHashMap<String, Bookmark>();

    private InMemoryBookmark() {
    }

    static InMemoryBookmark getInstance() {
        return instance;
    }

    @Override
    public String type() {
        return "InMemory";
    }

    @Override
    public final void set(String idempotentId, Bookmark bookmark) {
        this.inMemoryStore.put(idempotentId, bookmark);
    }

    @Override
    public final Bookmark get(String idempotentId, Bookmark initial) {
        return this.inMemoryStore.computeIfAbsent(idempotentId, x -> initial);
    }
}

