/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.flows.core;

import com.simplj.flows.core.Var;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class Session {
    private static final transient ThreadLocal<Session> THREAD_LOCAL = new ThreadLocal();
    private final Map<String, Object> objMap = new HashMap<String, Object>();

    protected Session() {
    }

    static void set(Session session) {
        if (session != null && THREAD_LOCAL.get() == null) {
            THREAD_LOCAL.set(session);
        }
    }

    static void update(Session session) {
        if (session != null) {
            THREAD_LOCAL.set(session);
        }
    }

    static Session current() {
        return THREAD_LOCAL.get();
    }

    public static <T> void set(String key, T value) {
        Session s = THREAD_LOCAL.get();
        if (s == null) {
            s = new Session();
        }
        s.objMap.put(key, value);
        THREAD_LOCAL.set(s);
    }

    public static <T> void set(Var ... vars) {
        Session s = THREAD_LOCAL.get();
        if (s == null) {
            s = new Session();
        }
        for (Var v : vars) {
            s.objMap.put(v.key(), v.val());
        }
        THREAD_LOCAL.set(s);
    }

    public static <T> T get(String key, Class<T> type) {
        return Session.getOpt(key, type).orElse(null);
    }

    public static <T> T get(String key, T defaultVal) {
        return (T)Optional.ofNullable(THREAD_LOCAL.get()).map(s -> s.objMap.get(key)).filter(defaultVal.getClass()::isInstance).map(x -> x).orElse(defaultVal);
    }

    public static <E extends Exception, T> T getOrThrow(String key, Class<T> type, E ex) throws E {
        return Session.getOpt(key, type).orElseThrow(() -> ex);
    }

    public static <T> T evict(String key, Class<T> type) {
        return Optional.ofNullable(THREAD_LOCAL.get()).map(s -> s.objMap.remove(key)).filter(type::isInstance).map(type::cast).orElse(null);
    }

    public static Byte getByte(String key) {
        return (Byte)((Object)Session.get(key, Byte.class));
    }

    public static Boolean getBool(String key) {
        return (Boolean)((Object)Session.get(key, Boolean.class));
    }

    public static Character getChar(String key) {
        return (Character)((Object)Session.get(key, Character.class));
    }

    public static Short getShort(String key) {
        return (Short)((Object)Session.get(key, Short.class));
    }

    public static Integer getInt(String key) {
        return (Integer)((Object)Session.get(key, Integer.class));
    }

    public static Long getLong(String key) {
        return (Long)((Object)Session.get(key, Long.class));
    }

    public static Float getFloat(String key) {
        return (Float)((Object)Session.get(key, Float.class));
    }

    public static Double getDouble(String key) {
        return (Double)((Object)Session.get(key, Double.class));
    }

    public static LocalDate getDate(String key) {
        return (LocalDate)((Object)Session.get(key, LocalDate.class));
    }

    public static LocalDateTime getDateTime(String key) {
        return (LocalDateTime)((Object)Session.get(key, LocalDateTime.class));
    }

    public static String get(String key) {
        return (String)((Object)Session.get(key, String.class));
    }

    public static Byte getByte(String key, byte defaultVal) {
        return Session.getOpt(key, Byte.class).orElse(defaultVal);
    }

    public static Boolean getBool(String key, boolean defaultVal) {
        return Session.getOpt(key, Boolean.class).orElse(defaultVal);
    }

    public static Character getChar(String key, char defaultVal) {
        return Session.getOpt(key, Character.class).orElse(Character.valueOf(defaultVal));
    }

    public static Short getShort(String key, short defaultVal) {
        return Session.getOpt(key, Short.class).orElse(defaultVal);
    }

    public static Integer getInt(String key, int defaultVal) {
        return Session.getOpt(key, Integer.class).orElse(defaultVal);
    }

    public static Long getLong(String key, long defaultVal) {
        return Session.getOpt(key, Long.class).orElse(defaultVal);
    }

    public static Float getFloat(String key, float defaultVal) {
        return Session.getOpt(key, Float.class).orElse(Float.valueOf(defaultVal));
    }

    public static Double getDouble(String key, double defaultVal) {
        return Session.getOpt(key, Double.class).orElse(defaultVal);
    }

    public static LocalDate getDate(String key, LocalDate defaultVal) {
        return Session.getOpt(key, LocalDate.class).orElse(defaultVal);
    }

    public static LocalDateTime getDateTime(String key, LocalDateTime defaultVal) {
        return Session.getOpt(key, LocalDateTime.class).orElse(defaultVal);
    }

    public static String get(String key, String defaultVal) {
        return Session.getOpt(key, String.class).orElse(defaultVal);
    }

    public static Byte evictByte(String key) {
        return Session.evict(key, Byte.class);
    }

    public static Boolean evictBool(String key) {
        return Session.evict(key, Boolean.class);
    }

    public static Character evictChar(String key) {
        return Session.evict(key, Character.class);
    }

    public static Short evictShort(String key) {
        return Session.evict(key, Short.class);
    }

    public static Integer evictInt(String key) {
        return Session.evict(key, Integer.class);
    }

    public static Long evictLong(String key) {
        return Session.evict(key, Long.class);
    }

    public static Float evictFloat(String key) {
        return Session.evict(key, Float.class);
    }

    public static Double evictDouble(String key) {
        return Session.evict(key, Double.class);
    }

    public static LocalDate evictDate(String key) {
        return Session.evict(key, LocalDate.class);
    }

    public static LocalDateTime evictDateTime(String key) {
        return Session.evict(key, LocalDateTime.class);
    }

    public static String evict(String key) {
        return Session.evict(key, String.class);
    }

    private static <T> Optional<T> getOpt(String key, Class<T> type) {
        return Optional.ofNullable(THREAD_LOCAL.get()).map(s -> s.objMap.get(key)).filter(type::isInstance).map(type::cast);
    }
}

