/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.flows.core;

import com.simplj.di.core.DependencyResolver;
import com.simplj.di.core.DependencyResolverConfig;
import com.simplj.di.core.DependencyResolverFactory;
import com.simplj.flows.FlowsModule;
import com.simplj.flows.core.BookmarkStore;
import com.simplj.flows.core.InMemoryBookmark;
import com.simplj.flows.core.SjfExtension;
import com.simplj.flows.exceptions.SjfException;
import com.simplj.flows.steps.StepsModule;
import com.simplj.lambda.function.Consumer;
import com.simplj.lambda.util.Try;
import com.simplj.lambda.util.retry.RetryContext;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class SjfConfiguration {
    private static final String SJF_CONTEXT = "sjf-core";
    private static SjfConfiguration instance;
    private final List<Object> modules;
    private final List<String> packages;
    private final Consumer<String> logger;
    private final RetryContext retryContext;
    private final Consumer<Exception> errorNotifier;
    private final ExecutorService errNotExecService;
    private final DependencyResolver dependencyResolver;
    private final BookmarkStore bookmarkStore;

    private SjfConfiguration(List<Object> modules, List<String> packages, Consumer<String> logger, RetryContext retryContext, Consumer<Exception> errorNotifier) {
        this.modules = modules;
        this.packages = packages;
        this.logger = Optional.ofNullable(logger).orElse((Consumer<String>)((Consumer)System.out::println));
        this.retryContext = retryContext;
        this.errorNotifier = errorNotifier;
        if (errorNotifier != null) {
            this.errNotExecService = Executors.newSingleThreadExecutor();
            Runtime.getRuntime().addShutdownHook(new Thread(this::onShutdown));
            System.out.println("/***\nSJF Tip:\n\tErrors will be notified in a background thread using a single thread pool executor! Hence, consider calling `SjfConfiguration.configuredInstance.erase()` on exit to clear shutdown the executor and exit properly.\n\tHowever, a shutdown hook will clear the resources on force exit of the application!\n***/");
        } else {
            this.errNotExecService = null;
        }
        this.dependencyResolver = this.initDependencyResolver();
        this.bookmarkStore = this.findBookmarkStore();
    }

    private DependencyResolver initDependencyResolver() {
        Object[] moduleArr = new Object[this.modules.size()];
        int idx = 0;
        for (Object object : this.modules) {
            moduleArr[idx++] = object;
        }
        String[] packageArr = new String[this.packages.size()];
        idx = 0;
        for (String pkg : this.packages) {
            packageArr[idx++] = pkg;
        }
        DependencyResolverConfig.Builder builder = DependencyResolverConfig.builder();
        builder.setLoggerF(arg_0 -> this.logger.consume(arg_0));
        DependencyResolverConfig config = builder.setDependencyProviders(moduleArr).setBasePackages(packageArr).build();
        DependencyResolverFactory.configureResolver((String)SJF_CONTEXT, (DependencyResolverConfig)config);
        return DependencyResolverFactory.resolver((String)SJF_CONTEXT);
    }

    private BookmarkStore findBookmarkStore() {
        String bookmarkStoreId = System.getProperty("sjf.bookmark.store.id", null);
        BookmarkStore res = bookmarkStoreId == null ? (BookmarkStore)Try.execute(() -> (BookmarkStore)this.dependencyResolver.resolve(BookmarkStore.class)).log(x -> this.logger.consume((Object)" - SJF: Using default In-Memory BookmarkStore as none is provided explicitly!")).recover(x -> InMemoryBookmark.getInstance()).result().right() : (BookmarkStore)Try.execute(() -> (BookmarkStore)this.dependencyResolver.resolve(bookmarkStoreId, BookmarkStore.class)).mapException(x -> new SjfException("Could not resolve any BookmarkStore instance against id \"" + bookmarkStoreId + "\" (Provided in 'sjf.bookmark.store.id' system property)!\nHint: Provide the dependency as SjfExtension or remove the id from system properties.")).resultOrThrow();
        return res;
    }

    private void onShutdown() {
        System.out.println("Shutdown initiated - clearing SjfConfiguration...");
        this.erase();
        System.out.println("Shutdown initiated - cleared SjfConfiguration!");
    }

    public void erase() {
        if (this.errNotExecService != null && !this.errNotExecService.isShutdown()) {
            this.errNotExecService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void configure(List<Object> modules, List<String> packages, Consumer<String> logger, RetryContext retryContext, Consumer<Exception> errorNotifier) {
        if (instance != null) return;
        Class<SjfConfiguration> clazz = SjfConfiguration.class;
        synchronized (SjfConfiguration.class) {
            if (instance != null) return;
            instance = new SjfConfiguration(modules, packages, logger, retryContext, errorNotifier);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    public static SjfConfiguration configuredInstance() {
        return instance;
    }

    public static SjfDefaultConfiguration defaultConfiguration() {
        LinkedList<Object> modules = new LinkedList<Object>();
        LinkedList packages = new LinkedList();
        modules.add(new StepsModule());
        modules.add(new FlowsModule());
        return new SjfDefaultConfiguration(modules, packages);
    }

    public Consumer<String> defaultLogger() {
        return this.logger;
    }

    public RetryContext defaultRetryContext() {
        return this.retryContext;
    }

    public void notifyError(Exception ex) {
        if (this.errorNotifier != null) {
            this.backgroundNotifyError(Thread.currentThread().getName(), ex);
        }
    }

    private void backgroundNotifyError(String tName, Exception ex) {
        this.defaultLogger().consume((Object)(tName + " - Notifying application about exception type '" + ex.getClass().getSimpleName() + "'!"));
        long s = System.currentTimeMillis();
        this.errorNotifier.consume((Object)ex);
        long e = System.currentTimeMillis() - s;
        this.defaultLogger().consume((Object)(tName + " - Notified application about exception! Took " + e + " millis."));
    }

    DependencyResolver getDependencyResolver() {
        return this.dependencyResolver;
    }

    BookmarkStore getBookmarkStore() {
        return this.bookmarkStore;
    }

    static boolean isConfigured() {
        return instance != null;
    }

    public static final class SjfDefaultConfiguration {
        private final List<Object> modules;
        private final List<String> packages;
        private Consumer<String> defaultLogger;
        private RetryContext defaultRetryCtx;
        private Consumer<Exception> defaultErrNotifier;

        private SjfDefaultConfiguration(List<Object> modules, List<String> packages) {
            this.modules = modules;
            this.packages = packages;
        }

        public SjfDefaultConfiguration withDefaultLogger(Consumer<String> logger) {
            this.defaultLogger = logger;
            return this;
        }

        public SjfDefaultConfiguration withDefaultRetryContext(RetryContext retryContext) {
            this.defaultRetryCtx = retryContext;
            return this;
        }

        public SjfDefaultConfiguration withDefaultErrorNotifier(Consumer<Exception> errorNotifier) {
            this.defaultErrNotifier = errorNotifier;
            return this;
        }

        public final SjfDefaultConfiguration bindExtension(SjfExtension extension) {
            this.modules.addAll(extension.modules());
            this.packages.addAll(extension.packages());
            return this;
        }

        public final void configure() {
            SjfConfiguration.configure(this.modules, this.packages, (Consumer<String>)this.defaultLogger, this.defaultRetryCtx, (Consumer<Exception>)this.defaultErrNotifier);
        }
    }
}

