/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.flows.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class StepContext {
    private static final ThreadLocal<IO> tLocal = new ThreadLocal();

    private StepContext() {
    }

    public static StepContextInput stepName(String name) {
        tLocal.set(new IO().setName(name));
        return new StepContextInput();
    }

    public static void logInputs(Object ... args) {
        IO io = StepContext.getIO();
        tLocal.set(io.setInput(StepContext.str(args)));
    }

    public static void log(String msg) {
        IO io = StepContext.getIO();
        tLocal.set(io.log(msg));
    }

    public static void logValueChanges(Object ... changes) {
        IO io = StepContext.getIO();
        tLocal.set(io.setOutput(StepContext.str(changes)));
    }

    public static void error(Exception ex) {
        IO io = StepContext.getIO();
        tLocal.set(io.setEx(ex));
    }

    static Optional<String> stepName() {
        return Optional.ofNullable(tLocal.get()).map(IO::name).filter(s -> !s.isEmpty());
    }

    static String stepInput() {
        return Optional.ofNullable(tLocal.get()).map(IO::input).filter(s -> !s.isEmpty()).orElse(null);
    }

    static List<String> stepLogs() {
        return Optional.ofNullable(tLocal.get()).map(IO::logs).orElse(Collections.emptyList());
    }

    static String stepOutput() {
        return Optional.ofNullable(tLocal.get()).map(IO::output).filter(s -> !s.isEmpty()).orElse(null);
    }

    static Optional<Exception> stepException() {
        return Optional.ofNullable(tLocal.get()).map(IO::exception);
    }

    static void clear() {
        tLocal.remove();
    }

    private static String str(Object[] args) {
        return Arrays.stream(args).map(String::valueOf).collect(Collectors.joining(","));
    }

    private static IO getIO() {
        IO io = tLocal.get();
        if (io == null) {
            io = new IO();
        }
        return io;
    }

    private static class IO {
        private String name;
        private boolean isInputSet;
        private String input;
        private final List<String> logs = new LinkedList<String>();
        private String output;
        private Exception ex;

        private IO() {
        }

        String name() {
            return this.name;
        }

        IO setName(String name) {
            this.name = name;
            return this;
        }

        String input() {
            return this.input;
        }

        IO setInput(String str) {
            if (!this.isInputSet) {
                this.input = str;
                this.isInputSet = true;
            }
            return this;
        }

        List<String> logs() {
            return this.logs;
        }

        IO log(String log) {
            this.logs.add(log);
            return this;
        }

        String output() {
            return this.output;
        }

        IO setOutput(String str) {
            this.output = this.output == null ? str : String.format("%s,%s", this.output, str);
            return this;
        }

        Exception exception() {
            return this.ex;
        }

        IO setEx(Exception ex) {
            this.ex = ex;
            return this;
        }
    }

    public static class StepContextInput {
        private StepContextInput() {
        }

        public void logInputs(Object ... args) {
            StepContext.logInputs(args);
        }
    }
}

