/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.flows.core;

import com.simplj.flows.core.Input;
import com.simplj.flows.core.SjfUtil;
import com.simplj.flows.core.StepContext;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class StepFrame
implements Serializable {
    private final String name;
    private final String msg;
    private final String input;
    private final List<String> logs;
    private final List<StepFrame> subFrames;
    private final String output;
    private final long duration;
    private final Exception error;
    private String str;
    private String json;
    private boolean isFirst;

    StepFrame(String name, String msg, long duration) {
        this(name, msg, null, Collections.emptyList(), null, duration, null);
    }

    StepFrame(String name, String msg, Object output, long duration) {
        this(name, msg, null, Collections.emptyList(), output, duration, null);
    }

    StepFrame(String name, Input input, Object output, long duration) {
        this(name, null, input, Collections.emptyList(), output, duration, null);
    }

    StepFrame(String name, Input input, List<StepFrame> subSteps, Object output, long duration) {
        this(name, null, input, subSteps, output, duration, null);
    }

    static StepFrame error(String name, Input input, Exception error, long duration) {
        return new StepFrame(name, null, input, Collections.emptyList(), null, duration, error);
    }

    StepFrame(String name, String msg, Input input, List<StepFrame> subFrames, Object output, long duration, Exception error) {
        this.name = StepContext.stepName().orElse(name);
        String stepInput = StepContext.stepInput();
        String stepOutput = StepContext.stepOutput();
        this.input = Optional.ofNullable(input).map(inp -> inp.inputStr(stepInput)).map(Input::toString).orElse(null);
        this.msg = msg;
        this.logs = StepContext.stepLogs();
        this.subFrames = subFrames;
        this.output = Optional.ofNullable(stepOutput).orElse(Optional.ofNullable(output).map(SjfUtil::stringify).orElse(null));
        this.duration = duration;
        this.error = StepContext.stepException().orElse(error);
        StepContext.clear();
        this.isFirst = false;
    }

    public final String msg() {
        return this.msg;
    }

    public final String name() {
        return this.name;
    }

    public final String input() {
        return this.input;
    }

    public final List<String> logs() {
        return this.logs;
    }

    public final List<StepFrame> subFrames() {
        return this.subFrames;
    }

    public final String output() {
        return this.output;
    }

    public final long duration() {
        return this.duration;
    }

    public final String formattedDuration() {
        return this.formatMillis(this.duration);
    }

    public final Exception error() {
        return this.error;
    }

    public final String errorTraceString() {
        String res = null;
        if (this.error != null) {
            StringWriter sw = new StringWriter();
            this.error.printStackTrace(new PrintWriter(sw));
            res = sw.toString();
        }
        return res;
    }

    public final boolean isError() {
        return this.error != null;
    }

    void setFirst(boolean flag) {
        this.isFirst = flag;
    }

    public boolean isFirst() {
        return this.isFirst;
    }

    public final String toString() {
        if (this.str == null) {
            this.str = String.format("{%s: %s %s}", this.name, this.constructStr(), this.duration < 0L ? "" : '(' + this.formatMillis(this.duration) + ')');
        }
        return this.str;
    }

    public final String toJsonString() {
        if (this.json == null) {
            this.json = this.constructJson();
        }
        return this.json;
    }

    private String constructStr() {
        String inp = SjfUtil.tautString(this.input);
        String res = inp == null && this.msg != null ? (this.output == null ? this.msg : this.msg + " -> " + SjfUtil.tautString(this.output)) : (this.error == null ? inp + " -> " + SjfUtil.tautString(this.output) : inp + " -> Error: " + this.error.getMessage());
        return res;
    }

    private String constructJson() {
        String inp = this.input;
        String res = inp == null && this.msg != null ? (this.output == null ? String.format("{\"isFirst\": %s,\"name\": \"%s\",\"msg\": \"%s\",\"duration\": %s}", this.isFirst, this.name, this.msg, this.duration) : String.format("{\"isFirst\": %s,\"name\": \"%s\",\"msg\": \"%s\",\"output\": \"%s\",\"duration\": %s}", this.isFirst, this.name, this.msg, this.output, this.duration)) : (this.error == null ? String.format("{\"isFirst\": %s,\"name\": \"%s\",\"input\": \"%s\",\"logs\": [\"%s\"],\"subFlow\": [%s],\"output\": \"%s\",\"duration\": %s}", this.isFirst, this.name, inp, String.join((CharSequence)"\",\"", this.logs), this.subFrames.stream().map(StepFrame::toJsonString).collect(Collectors.joining(",")), this.output, this.duration) : String.format("{\"isFirst\": %s,\"name\": \"%s\",\"input\": \"%s\",\"logs\": [\"%s\"],\"subFlow\": [%s],\"error\": \"%s\",\"duration\": %s}", this.isFirst, this.name, inp, String.join((CharSequence)"\",\"", this.logs), this.subFrames.stream().map(StepFrame::toJsonString).collect(Collectors.joining(",")), this.errorTraceString().replace("\n", "\\n").replace("\t", "\\t"), this.duration));
        return res;
    }

    private String formatMillis(long duration) {
        StringBuilder sb = new StringBuilder();
        long millis = duration;
        if (millis > 1000L) {
            long secs = millis / 1000L;
            millis %= 1000L;
            if (secs > 60L) {
                long mins = secs / 60L;
                secs %= 60L;
                sb.append(mins).append("m ");
            }
            sb.append(secs).append("s ");
        }
        sb.append(millis).append("ms");
        return sb.toString();
    }
}

