/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.flows.core;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;

final class ThreadSafeList<E>
extends LinkedList<E> {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    ThreadSafeList(List<E> stepFrames) {
        this();
        this.addAll(stepFrames);
    }

    ThreadSafeList() {
    }

    @Override
    public final boolean add(E e) {
        this.lock.writeLock().lock();
        boolean res = super.add(e);
        this.lock.writeLock().unlock();
        return res;
    }

    @Override
    public final void add(int index, E e) {
        this.lock.writeLock().lock();
        super.add(index, e);
        this.lock.writeLock().unlock();
    }

    @Override
    public final boolean addAll(Collection<? extends E> sourceList) {
        this.lock.writeLock().lock();
        boolean res = super.addAll(sourceList);
        this.lock.writeLock().unlock();
        return res;
    }

    @Override
    public final E get(int index) {
        this.lock.readLock().lock();
        Object e = super.get(index);
        this.lock.readLock().unlock();
        return e;
    }

    @Override
    public final E getFirst() {
        this.lock.readLock().lock();
        Object e = super.getFirst();
        this.lock.readLock().unlock();
        return e;
    }

    @Override
    public final E getLast() {
        this.lock.readLock().lock();
        Object e = super.getLast();
        this.lock.readLock().unlock();
        return e;
    }

    @Override
    public final int size() {
        this.lock.readLock().lock();
        int size = super.size();
        this.lock.readLock().unlock();
        return size;
    }
}

