/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.flows.steps;

import com.simplj.flows.core.AbstractStep;
import com.simplj.flows.core.ExecutionResult;
import com.simplj.flows.exceptions.AsyncTimeoutException;
import com.simplj.flows.steps.AsyncCompletableStep;
import com.simplj.lambda.executable.BiExecutable;
import com.simplj.lambda.executable.Receiver;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public final class AsyncCompletable<I, T, R> {
    private final String key;
    private final Class<Future<ExecutionResult<T>>> type;
    private final BiExecutable<I, T, R> accumulator;
    private Receiver<AsyncTimeoutException> timeoutConsumer;

    AsyncCompletable(String key, Class<Future<ExecutionResult<T>>> type, BiExecutable<I, T, R> accumulator) {
        this.key = key;
        this.type = type;
        this.accumulator = accumulator;
    }

    public AbstractStep<I, R> waitForCompletion() {
        return new AsyncCompletableStep<I, T, R>(this.key, this.type, this.accumulator);
    }

    public AsyncCompletableStep<I, T, R> waitForCompletion(long timeout, TimeUnit unit) {
        return new AsyncCompletableStep<I, T, R>(this.key, this.type, this.accumulator, TimeUnit.MILLISECONDS.convert(timeout, unit), 500L);
    }

    public AsyncCompletableStep<I, T, R> waitForCompletion(long timeout, TimeUnit unit, long intervalInMillis) {
        return new AsyncCompletableStep<I, T, R>(this.key, this.type, this.accumulator, TimeUnit.MILLISECONDS.convert(timeout, unit), intervalInMillis);
    }
}

