/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.flows.steps;

import com.simplj.flows.core.AbstractStep;
import com.simplj.flows.core.ExecutionContext;
import com.simplj.flows.core.ExecutionResult;
import com.simplj.flows.core.Input;
import com.simplj.flows.exceptions.AsyncTimeoutException;
import com.simplj.flows.exceptions.CompletableNotFoundException;
import com.simplj.flows.exceptions.SjfException;
import com.simplj.flows.steps.Step;
import com.simplj.lambda.executable.BiExecutable;
import com.simplj.lambda.function.Condition;
import com.simplj.lambda.function.Consumer;
import java.util.concurrent.Future;

public final class AsyncCompletableStep<I, T, R>
extends Step<I, R> {
    private final String key;
    private final Class<Future<ExecutionResult<T>>> type;
    private final BiExecutable<I, T, R> accumulator;
    private final long maxWaitMillis;
    private final long intervalMillis;
    private Consumer<AsyncTimeoutException> timeoutConsumer;

    AsyncCompletableStep(String key, Class<Future<ExecutionResult<T>>> type, BiExecutable<I, T, R> accumulator) {
        this(key, type, accumulator, -1L, 0L);
    }

    AsyncCompletableStep(String key, Class<Future<ExecutionResult<T>>> type, BiExecutable<I, T, R> accumulator, long maxWaitMillis, long intervalMillis) {
        super(key + "-completable");
        this.key = key;
        this.type = type;
        this.accumulator = accumulator;
        this.maxWaitMillis = maxWaitMillis;
        this.intervalMillis = intervalMillis;
    }

    public final AbstractStep<I, R> onTimeout(Consumer<AsyncTimeoutException> timeoutHandler) {
        this.timeoutConsumer = timeoutHandler;
        return this;
    }

    @Override
    protected ExecutionResult<R> execute(ExecutionContext ctx, I input) {
        ExecutionResult<Object> res;
        Input inp = Input.of(input);
        long s = System.currentTimeMillis();
        try {
            Future future = AsyncCompletableStep.getVar(ctx, this.key, this.type, null);
            if (future == null) {
                res = AsyncCompletableStep.error(new CompletableNotFoundException(this.key, this.type.getTypeName()), ctx);
            } else {
                long ps = System.currentTimeMillis();
                AsyncCompletableStep.conditionalPause(Condition.negate(Future::isDone), future, this.maxWaitMillis, this.intervalMillis);
                long pe = System.currentTimeMillis();
                if (future.isDone()) {
                    AsyncCompletableStep.addFrame(ctx, AsyncCompletableStep.stepFrame(this.name(), "Obtained completable by key: " + this.key, pe - ps));
                    ExecutionResult fRes = (ExecutionResult)future.get();
                    res = fRes.isSuccess() ? AsyncCompletableStep.execute(this.accumulator, input, fRes.result(), ctx, this.name()) : AsyncCompletableStep.error(fRes.error(), ctx);
                } else {
                    future.cancel(true);
                    res = this.timedOutFlow(ctx, pe - ps);
                }
            }
        }
        catch (Exception ex) {
            res = AsyncCompletableStep.error(ex, AsyncCompletableStep.addFrame(ctx, AsyncCompletableStep.errStepFrame(this.name(), inp, new SjfException("Failed to obtain completable by key: " + this.key, ex), System.currentTimeMillis() - s)));
        }
        return res;
    }

    private ExecutionResult<R> timedOutFlow(ExecutionContext ctx, long duration) {
        AsyncTimeoutException e = new AsyncTimeoutException(this.name(), duration);
        AsyncCompletableStep.addFrame(ctx, AsyncCompletableStep.stepFrame(this.name(), "Asynchronous execution could not complete after " + duration + " millis!", duration));
        if (this.timeoutConsumer != null) {
            long s = System.currentTimeMillis();
            this.timeoutConsumer.consume((Object)e);
            AsyncCompletableStep.addFrame(ctx, AsyncCompletableStep.stepFrame(this.name() + "-timeout-handler", "TimeOut handler for step " + this.name() + " executed!", System.currentTimeMillis() - s));
        }
        ExecutionResult res = AsyncCompletableStep.error(e, ctx);
        return res;
    }
}

