/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.flows.steps;

import com.simplj.flows.core.AbstractStep;
import com.simplj.flows.core.ExecutionContext;
import com.simplj.flows.core.ExecutionResult;
import com.simplj.flows.core.Input;
import com.simplj.flows.core.Session;
import com.simplj.flows.exceptions.SjfException;
import com.simplj.flows.steps.Step;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

public final class AsyncRetainerStep<I, O>
extends Step<I, I> {
    private final AbstractStep<I, O> step;
    private final ExecutorService es;
    private final String varName;

    AsyncRetainerStep(AbstractStep<I, O> step, ExecutorService es, String varName) {
        super(AsyncRetainerStep.name(step));
        this.step = step;
        this.es = es;
        this.varName = varName;
    }

    @Override
    protected ExecutionResult<I> execute(ExecutionContext ctx, I input) {
        ExecutionResult<Object> res;
        Input inp = Input.of(input);
        try {
            Future<ExecutionResult> future;
            Session s = AsyncRetainerStep.session();
            Callable<ExecutionResult> callable = () -> AsyncRetainerStep.execute(this.step, input, AsyncRetainerStep.copy(ctx, s));
            if (this.es == null) {
                FutureTask<ExecutionResult> task = new FutureTask<ExecutionResult>(callable);
                new Thread(task).start();
                future = task;
            } else {
                future = this.es.submit(callable);
            }
            AsyncRetainerStep.addFrame(ctx, AsyncRetainerStep.stepFrame(this.name(), "Triggered completable async step!"));
            AsyncRetainerStep.setVar(ctx, this.varName, future);
            res = AsyncRetainerStep.success(input, AsyncRetainerStep.addFrame(ctx, AsyncRetainerStep.stepFrame(this.name(), "Retained completable by key: " + this.varName)));
        }
        catch (Exception ex) {
            res = AsyncRetainerStep.error(ex, AsyncRetainerStep.addFrame(ctx, AsyncRetainerStep.errStepFrame(this.name(), inp, new SjfException("Error triggering async step: " + this.name(), ex), 0L)));
        }
        return res;
    }
}

