/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.flows.steps;

import com.simplj.flows.core.AbstractStep;
import com.simplj.flows.core.ExecutionContext;
import com.simplj.flows.core.ExecutionResult;
import com.simplj.flows.core.Input;
import com.simplj.flows.core.Session;
import com.simplj.flows.exceptions.SjfException;
import com.simplj.flows.steps.Step;
import com.simplj.lambda.function.BiConsumer;
import com.simplj.lambda.function.Consumer;
import java.util.concurrent.ExecutorService;

final class AsyncStep<T, R>
extends Step<T, T> {
    private final Consumer<T> pre;
    private final AbstractStep<T, R> step;
    private final BiConsumer<T, R> post;
    private final BiConsumer<T, Exception> errNotifier;
    private final ExecutorService es;

    AsyncStep(Consumer<T> pre, AbstractStep<T, R> step, BiConsumer<T, R> post, BiConsumer<T, Exception> errNotifier, ExecutorService es) {
        super(AsyncStep.name(step));
        this.pre = pre;
        this.step = step;
        this.post = post;
        this.errNotifier = errNotifier;
        this.es = es;
    }

    @Override
    protected ExecutionResult<T> execute(ExecutionContext ctx, T input) {
        ExecutionResult<T> res;
        Input inp = Input.of(input);
        try {
            Session s = AsyncStep.session();
            Runnable runnable = () -> this.executeStep(ctx, input, s);
            if (this.es == null) {
                new Thread(runnable).start();
            } else {
                this.es.submit(runnable);
            }
            res = AsyncStep.success(input, AsyncStep.addFrame(ctx, AsyncStep.stepFrame(this.name(), "triggered async step!")));
        }
        catch (Exception ex) {
            res = AsyncStep.error(ex, AsyncStep.addFrame(ctx, AsyncStep.errStepFrame(this.name(), inp, new SjfException("Error triggering async step: " + this.name(), ex), 0L)));
        }
        return res;
    }

    private void executeStep(ExecutionContext ctx, T input, Session s) {
        this.pre.consume(input);
        ExecutionResult<R> res = AsyncStep.execute(this.step, input, AsyncStep.copy(ctx, s));
        if (res.isSuccess()) {
            this.post.consume(input, res.result());
        } else {
            this.errNotifier.consume(input, (Object)res.error());
        }
    }
}

