/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.flows.steps;

import com.simplj.flows.core.AbstractStep;
import com.simplj.flows.steps.AsyncExecutorStep;
import com.simplj.flows.steps.AsyncRetainerStep;
import com.simplj.flows.steps.Step;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public class AsyncStepBuilder<T, R> {
    private final AbstractStep<T, R> step;
    private final ExecutorService es;

    AsyncStepBuilder(AbstractStep<T, R> step, ExecutorService es) {
        this.step = step;
        this.es = es;
    }

    public Step<T, T> retainCompletable(String name) {
        return new AsyncRetainerStep<T, R>(this.step, this.es, name);
    }

    public Step<T, R> waitForCompletion() {
        return new AsyncExecutorStep<T, R>(this.step, this.es);
    }

    public AsyncExecutorStep<T, R> waitForCompletion(long timeout, TimeUnit unit) {
        return new AsyncExecutorStep<T, R>(this.step, this.es, TimeUnit.MILLISECONDS.convert(timeout, unit), 500L);
    }

    public AsyncExecutorStep<T, R> waitForCompletion(long timeout, TimeUnit unit, long intervalInMillis) {
        return new AsyncExecutorStep<T, R>(this.step, this.es, TimeUnit.MILLISECONDS.convert(timeout, unit), intervalInMillis);
    }
}

