/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.flows.steps;

import com.simplj.flows.core.AbstractStep;
import com.simplj.flows.core.BookmarkState;
import com.simplj.flows.core.BookmarkStore;
import com.simplj.flows.core.ExecutionContext;
import com.simplj.flows.core.ExecutionResult;
import com.simplj.flows.core.Input;
import com.simplj.flows.exceptions.DuplicateBookmarkNameException;
import com.simplj.flows.steps.Step;
import com.simplj.lambda.data.Util;
import com.simplj.lambda.executable.BiExecutable;
import com.simplj.lambda.function.Function;
import com.simplj.lambda.util.Either;
import com.simplj.lambda.util.Timed;
import com.simplj.lambda.util.Try;

public final class BookmarkStep<I, O>
extends Step<I, O> {
    private final BookmarkStore defaultBookmarkStore = BookmarkStep.getBookmarkStore();
    private final Function<I, String> flowNameF;
    private final String bookmarkName;
    private final BiExecutable<I, O, O> mergeF;
    private final AbstractStep<I, O> step;

    BookmarkStep(Function<I, String> flowNameF, String bookmarkName, BiExecutable<I, O, O> mergeF, AbstractStep<I, O> step) {
        super(bookmarkName);
        this.flowNameF = flowNameF;
        this.bookmarkName = bookmarkName;
        this.mergeF = mergeF;
        this.step = step;
    }

    @Override
    protected final ExecutionResult<O> execute(ExecutionContext ctx, I input) {
        ExecutionResult<Object> res;
        String flowName = (String)this.flowNameF.apply(input);
        String fqBookmarkName = flowName + '-' + this.bookmarkName;
        BookmarkStore bookmarkStore = BookmarkStep.getBookmarkStore(ctx, this.defaultBookmarkStore);
        int r = BookmarkStep.validateUniqueness(bookmarkStore, ctx, fqBookmarkName);
        switch (r) {
            case 1: {
                res = BookmarkStep.error(new DuplicateBookmarkNameException(fqBookmarkName, "Flow and Bookmark name combination '" + fqBookmarkName + "' is not unique in the flow execution! Bookmark name (along with flow name if used) must be unique in a flow."), ctx);
                break;
            }
            case 2: {
                res = BookmarkStep.error(new IllegalStateException("Multiple retry attempted! Flow is already being retried with idempotentId " + ctx.idempotentId() + '!'), ctx);
                break;
            }
            default: {
                res = this.executeStep(bookmarkStore, ctx, input, flowName, fqBookmarkName);
            }
        }
        BookmarkStep.cleanup(bookmarkStore, ctx.idempotentId(), fqBookmarkName);
        return res;
    }

    private ExecutionResult<O> executeStep(BookmarkStore bookmarkStore, ExecutionContext ctx, I input, String flowName, String fqBookmarkName) {
        ExecutionResult<Object> res = null;
        BookmarkState bookmarkState = null;
        Either e = Try.execute(() -> BookmarkStep.retrieve(bookmarkStore, ctx, flowName)).result();
        if (e.isRight()) {
            bookmarkState = (BookmarkState)e.right();
        } else {
            ((Exception)e.left()).printStackTrace();
            res = BookmarkStep.error((Exception)e.left(), BookmarkStep.addFrame(ctx, BookmarkStep.errStepFrame(flowName + "-bookmark-get", Input.of(ctx.idempotentId()), (Exception)e.left(), -1L)));
        }
        if (bookmarkState != null && this.bookmarkName.equals(bookmarkState.getName())) {
            try {
                Object o = Util.cast((Object)bookmarkState.getValue());
                res = this.merge(ctx, input, fqBookmarkName, o);
            }
            catch (Exception ex) {
                res = BookmarkStep.error(ex, BookmarkStep.addFrame(ctx, BookmarkStep.stepFrame(flowName + "-bookmark", "Existing bookmark value not matching expected type! Bookmarked Type: " + bookmarkState.getValue().getClass().getTypeName())));
            }
        }
        if (res == null && (res = BookmarkStep.execute(this.step, input, ctx)).isSuccess()) {
            res = BookmarkStep.save(ctx, bookmarkStore, flowName, this.bookmarkName, fqBookmarkName, res);
        }
        return res;
    }

    private ExecutionResult<O> merge(ExecutionContext ctx, I input, String name, O o) {
        ExecutionResult<Object> res;
        try {
            Timed.TimedExecution r = Timed.execute(() -> this.mergeF.execute(input, o));
            res = BookmarkStep.success(r.result(), BookmarkStep.addFrame(ctx, BookmarkStep.stepFrame(name, "Fetched bookmarked value!", r.result(), r.duration())));
        }
        catch (Exception ex) {
            res = BookmarkStep.error(ex, BookmarkStep.addFrame(ctx, BookmarkStep.stepFrame(name + "-merge", ex.getMessage())));
        }
        return res;
    }
}

