/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.flows.steps;

import com.simplj.flows.core.AbstractStep;
import com.simplj.flows.core.ExecutionContext;
import com.simplj.flows.core.ExecutionResult;
import com.simplj.flows.exceptions.PatternExhaustedException;
import com.simplj.flows.steps.NestedStep;
import com.simplj.flows.steps.PartialStep;
import com.simplj.flows.steps.Step;
import com.simplj.lambda.executable.Executable;
import com.simplj.lambda.function.Function;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class ComparableStep<I, T, O>
extends NestedStep<I, O> {
    private AbstractStep<I, O> defaultStep;
    private final Function<I, T> extractor;
    private final Map<T, AbstractStep<I, O>> comparableSteps;

    ComparableStep(String name, Function<I, T> extractor, AbstractStep<I, O> step, List<T> keys) {
        super(name);
        this.extractor = extractor;
        this.comparableSteps = new HashMap<T, AbstractStep<I, O>>();
        keys.forEach(k -> this.comparableSteps.put(k, step));
    }

    public final PartialStep<I, O, ComparableStep<I, T, O>> match(T key) {
        return new Match(key);
    }

    public final Step<I, O> otherwise(Executable<I, O> defaultExecutable) {
        return this.otherwise(Step.lift(this.name() + "::default", defaultExecutable));
    }

    public final Step<I, O> otherwise(AbstractStep<I, O> defaultStep) {
        this.defaultStep = defaultStep;
        return this;
    }

    @Override
    protected final ExecutionResult<O> executeStep(ExecutionContext ctx, I input) {
        AbstractStep<I, O> step = this.comparableSteps.get(this.extractor.apply(input));
        ExecutionResult<Object> res = step == null ? (this.defaultStep == null ? ComparableStep.error(new PatternExhaustedException(this.name(), input), ctx) : ComparableStep.execute(this.defaultStep, input, ctx)) : ComparableStep.execute(step, input, ctx);
        return res;
    }

    private ComparableStep<I, T, O> addStep(List<T> keys, AbstractStep<I, O> step) {
        keys.forEach(k -> this.comparableSteps.put(k, step));
        return this;
    }

    private class Match
    implements PartialStep<I, O, ComparableStep<I, T, O>> {
        private final List<T> keys = new LinkedList();

        private Match(T key) {
            this.keys.add(key);
        }

        public final Match or(T key) {
            this.keys.add(key);
            return this;
        }

        @Override
        public final ComparableStep<I, T, O> then(Executable<I, O> executable) {
            return this.then((AbstractStep)Step.lift("match-" + this.keys, executable));
        }

        @Override
        public final ComparableStep<I, T, O> then(AbstractStep<I, O> step) {
            return ComparableStep.this.addStep(this.keys, step);
        }
    }
}

