/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.flows.steps;

import com.simplj.flows.core.AbstractStep;
import com.simplj.flows.steps.ComparableStep;
import com.simplj.flows.steps.Step;
import com.simplj.lambda.executable.Executable;
import com.simplj.lambda.function.Function;
import java.util.LinkedList;
import java.util.List;

public final class ComparableStepBuilder {
    private final String stepName;

    ComparableStepBuilder(String name) {
        this.stepName = name;
    }

    public final <T> PartialComparableStep<T, T> match(T keys) {
        return new PartialComparableStep(this.stepName, Function.id(), keys);
    }

    public final <I, T> TypedComparableStepBuilder<I, T> on(Function<I, T> f) {
        return new TypedComparableStepBuilder<I, T>(this.stepName, f);
    }

    public static class TypedComparableStepBuilder<I, T> {
        private final String stepName;
        private final Function<I, T> extractor;

        TypedComparableStepBuilder(String name, Function<I, T> f) {
            this.stepName = name;
            this.extractor = f;
        }

        public final PartialComparableStep<I, T> match(T keys) {
            return new PartialComparableStep(this.stepName, this.extractor, keys);
        }
    }

    public static class PartialComparableStep<I, T> {
        private final String name;
        private final List<T> keys;
        private final Function<I, T> extractor;

        private PartialComparableStep(String name, Function<I, T> f, T key) {
            this.name = name;
            this.extractor = f;
            this.keys = new LinkedList<T>();
            this.keys.add(key);
        }

        public final PartialComparableStep<I, T> or(T key) {
            this.keys.add(key);
            return this;
        }

        public final <R> ComparableStep<I, T, R> then(Executable<I, R> executable) {
            return this.then(Step.lift("match-" + this.keys, executable));
        }

        public final <R> ComparableStep<I, T, R> then(AbstractStep<I, R> step) {
            return new ComparableStep<I, T, R>(this.name, this.extractor, step, this.keys);
        }
    }
}

